<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\User;
use Illuminate\Console\Command;
use App\Models\ExpiredUserPackage;
use App\Models\PlanHisory;

class CheckExpiredPlans extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'plans:expire-check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Checks and expires user plans that have ended';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $expiredUsers = User::with('plan')
            ->whereNotNull('plan_end_date')
            ->where('plan_end_date', '<', now())
            ->whereNotNull('plan_id')
            ->get();

        if ($expiredUsers->isEmpty()) {
            $this->info('No expired plans found.');
            return;
        }

        foreach ($expiredUsers as $user) {
            $plan = $user->plan;

            // Use plan_type directly as number of days
            $duration = is_numeric($plan?->plan_type) ? (int) $plan->plan_type : 30;

            PlanHisory::where('user_id', $user->id)
                ->where('plan_id', $user->plan_id)
                ->update([
                    'status'   => 0,
                ]);

            // Reset plan info
            $user->update([
                'plan_id'       => null,
                'ad_limit'      => 0,
                'plan_end_date' => null,
            ]);
        }

        $this->info("Expired plans processed: {$expiredUsers->count()}");
    }
}
