<?php

namespace App\Console\Commands;

use App\Models\Property;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Console\Command;

class ExpirePremiumProperties extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:expire-premium-properties';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Mark expired premium properties as expired';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $expiredProperties = Property::where('is_primium', '!=', 2)
            ->whereDate('expire_date', '<=', now())
            ->get();

        $ids = $expiredProperties->pluck('id')->toArray();

        foreach ($ids as $id) {
            $this->line(" - Property ID: {$id}");
        }

        Log::info('[ExpirePremiumProperties] Expiring properties with IDs:', $ids);

        // Update
        Property::whereIn('id', $ids)
            ->update(['is_primium' => 2]);

        $this->info('Expired premium properties updated.');
        Log::info('[ExpirePremiumProperties] Update complete.');
    }
}
