<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AdminUserConversation;
use App\Models\Blog;
use App\Models\Currency;
use App\Models\Deposit;
use App\Models\Invest;
use App\Models\MoneyRequest;
use App\Models\Order;
use App\Models\Plan;
use App\Models\Property;
use App\Models\ReferralBonus;
use App\Models\Transaction;
use App\Models\User;
use App\Models\Withdraw;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use InvalidArgumentException;
use Zip;

class DashboardController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function index()
    {
        $data['blogs'] = Blog::all();
        $data['deposits'] = Deposit::all();
        $data['orders'] = Order::all();
        $data['withdrawAmount'] = Withdraw::sum('amount');
        $data['withdrawChargeAmount'] = Withdraw::sum('fee');
        $data['currency'] = Currency::whereIsDefault(1)->first();
        $data['transactions'] = Transaction::all();
        $data['plans'] = Plan::all();
        $data['properties'] = Property::whereIsInvest(0)->get();
        $data['invest_properties'] = Property::whereIsInvest(1)->get();
        $data['invests'] = Invest::all();

        $data['tickets'] = AdminUserConversation::all();
        $data['bonus'] = ReferralBonus::sum('amount');
        $data['acustomers'] = User::orderBy('id', 'desc')->whereIsBanned(0)->get();
        $data['bcustomers'] = User::orderBy('id', 'desc')->whereIsBanned(1)->get();
        $data['users'] = User::withCount('properties')->orderBy('id', 'desc')->paginate(10);
        $data['payouts'] = Withdraw::where('status', 'completed')->sum('amount');

        $data['activation_notify'] = "";
        if (file_exists(public_path() . '/rooted.txt')) {
            $rooted = file_get_contents(public_path() . '/rooted.txt');
            if ($rooted < date('Y-m-d', strtotime("+10 days"))) {
                $activation_notify = "<i class='icofont-warning-alt icofont-4x'></i><br>Please activate your system.<br> If you do not activate your system now, it will be inactive on " . $rooted . "!!<br><a href='" . url('/admin/activation') . "' class='btn btn-success'>Activate Now</a>";
            }
        }
        session(['admin_otp_verified' => false]);
        return view('admin.dashboard', $data);
    }

    public function passwordreset()
    {
        $data = Auth::guard('admin')->user();
        return view('admin.password', compact('data'));
    }

    public function changepass(Request $request)
    {
        $admin = Auth::guard('admin')->user();
        if ($request->cpass) {
            if (Hash::check($request->cpass, $admin->password)) {
                if ($request->newpass == $request->renewpass) {
                    $input['password'] = Hash::make($request->newpass);
                } else {
                    return response()->json(array('errors' => [0 => 'Confirm password does not match.']));
                }
            } else {
                return response()->json(array('errors' => [0 => 'Current password Does not match.']));
            }
        }
        $admin->update($input);
        $msg = 'Successfully change your password';
        return response()->json($msg);
    }

    public function profile()
    {
        $data = Auth::guard('admin')->user();
        return view('admin.profile', compact('data'));
    }

    public function profileupdate(Request $request)
    {
        $rules =
            [
                'photo' => 'mimes:jpeg,jpg,png,svg',
                'email' => 'unique:admins,email,' . Auth::guard('admin')->user()->id
            ];


        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json(array('errors' => $validator->getMessageBag()->toArray()));
        }
        //--- Validation Section Ends
        $input = $request->all();
        $data = Auth::guard('admin')->user();
        if ($file = $request->file('photo')) {
            $name = Str::random(8) . time() . '.' . $file->getClientOriginalExtension();
            $file->move('assets/images/', $name);
            if ($data->photo != null) {
                if (file_exists(public_path() . '/assets/images/' . $data->photo)) {
                    unlink(public_path() . '/assets/images/' . $data->photo);
                }
            }
            $input['photo'] = $name;
        }

        $input['slug'] = str_replace(" ", "-", $input['name']);


        $data->update($input);
        $msg = 'Successfully updated your profile';
        return response()->json($msg);
    }

    public function generate_bkup()
    {
        $bkuplink = "";
        $chk = file_get_contents('backup.txt');
        if ($chk != "") {
            $bkuplink = url($chk);
        }
        return view('admin.movetoserver', compact('bkuplink', 'chk'));
    }

    public function clear_bkup()
    {
        $destination  = public_path() . '/install';
        $bkuplink = "";
        $chk = file_get_contents('backup.txt');
        if ($chk != "") {
            unlink(public_path($chk));
        }

        if (is_dir($destination)) {
            $this->deleteDir($destination);
        }
        $handle = fopen('backup.txt', 'w+');
        fwrite($handle, "");
        fclose($handle);
        //return "No Backup File Generated.";
        return redirect()->back()->with('success', 'Backup file Deleted Successfully!');
    }

    public function activation()
    {
        $activation_data = "<i style='color:darkgreen;' class='icofont-check-circled icofont-4x'></i><br><h3 style='color:darkgreen;'>Your System is Activated!</h3><br> Your License Key:  <b>cc9df704-8db0-4ec6-822a-ef65c2c7b148</b>";
        return view('admin.activation', compact('activation_data'));
    }

    public function activation_submit(Request $request)
    {

        $purchase_code =  $request->pcode;
        $my_script =  'Property Genius';
        $my_domain = url('/');

        $varUrl = str_replace(' ', '%20', config('services.genius.ocean') . 'purchase112662activate.php?code=' . $purchase_code . '&domain=' . $my_domain . '&script=' . $my_script);

        if (ini_get('allow_url_fopen')) {
            $contents = file_get_contents($varUrl);
        } else {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $varUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $contents = curl_exec($ch);
            curl_close($ch);
        }

        $chk = json_decode($contents, true);

        if ($chk['status'] != "success") {

            $msg = $chk['message'];
            return response()->json($msg);
        } else {
            $this->setUp($chk['p2'], $chk['lData']);

            if (file_exists(public_path() . '/rooted.txt')) {
                unlink(public_path() . '/rooted.txt');
            }

            $fpbt = fopen(public_path() . '/project/license.txt', 'w');
            fwrite($fpbt, $purchase_code);
            fclose($fpbt);

            $msg = 'Congratulation!! Your System is successfully Activated.';
            return response()->json($msg);
        }
    }

    function setUp($mtFile, $goFileData)
    {
        $fpa = fopen(public_path() . $mtFile, 'w');
        fwrite($fpa, $goFileData);
        fclose($fpa);
    }

    public function movescript()
    {
        ini_set('max_execution_time', 3000);

        $destination  = public_path() . '/install';
        $chk = file_get_contents('backup.txt');
        if ($chk != "") {
            unlink(public_path($chk));
        }

        if (is_dir($destination)) {
            $this->deleteDir($destination);
        }
        $src = base_path() . '/vendor/update';
        $this->recurse_copy($src, $destination);
        $files = public_path();
        $bkupname = 'GeniusRealEstate-By-GeniusOcean-' . date('Y-m-d') . '.zip';
        $zip = Zip::create($bkupname)->add($files);
        $zip->close();

        $handle = fopen('backup.txt', 'w+');
        fwrite($handle, $bkupname);
        fclose($handle);

        if (is_dir($destination)) {
            $this->deleteDir($destination);
        }
        return response()->json(['status' => 'success', 'backupfile' => url($bkupname), 'filename' => $bkupname], 200);
    }

    public function recurse_copy($src, $dst)
    {
        $dir = opendir($src);
        @mkdir($dst);
        while (false !== ($file = readdir($dir))) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    $this->recurse_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    copy($src . '/' . $file, $dst . '/' . $file);
                }
            }
        }
        closedir($dir);
    }

    public function deleteDir($dirPath)
    {
        if (!is_dir($dirPath)) {
            throw new InvalidArgumentException("$dirPath must be a directory");
        }
        if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
            $dirPath .= '/';
        }
        $files = glob($dirPath . '*', GLOB_MARK);
        foreach ($files as $file) {
            if (is_dir($file)) {
                self::deleteDir($file);
            } else {
                unlink($file);
            }
        }
        rmdir($dirPath);
    }

    public function sendOtpToAdmin(Request $request)
    {
        $otp = rand(1000, 9999);
        $phone = '919993103682';
        session([
            'admin_otp' => $otp,
            'admin_otp_generated_at' => now(),
            'admin_otp_required' => true,
            'admin_otp_verified' => false,
        ]);

        $serviceName = 'Admin OTP service';
        $sendsmsService = app(\App\Services\SendSmsService::class);

        // Short and secure OTP message
        $otpMessage = "Your OTP for secure admin access is: $otp. Do not share this code.";

        // Send SMS
        $sendsmsService->sendOTPSMS($phone, $otp, $serviceName, $otpMessage);

        // Send Email
        $emailData = [
            'email' => 'raghu99931036@gmail.com',
            'name' => 'Admin',
            'subject' => 'Admin OTP for Secure Access',
            'message' => '<p>Your OTP for secure admin access is: <b>' . $otp . '</b><br>Do not share this code. It is valid for a limited time.</p>'
        ];

        if (function_exists('email')) {
            email($emailData);
        }

        if ($request->ajax() || $request->wantsJson()) {
            return response()->json(['success' => true, 'message' => 'OTP sent successfully!']);
        }

        return redirect()->back()->with('admin_otp_required', true);
    }

    public function verifyAdminOtp(Request $request)
    {
        $request->validate([
            'otp' => 'required|digits:4',
        ]);
        $inputOtp = trim($request->input('otp'));
        $storedOtp = session('admin_otp');
        $otpGeneratedAt = session('admin_otp_generated_at');
        if (!$storedOtp || !$otpGeneratedAt || now()->diffInSeconds($otpGeneratedAt) > 300) {
            return redirect()->back()->with('admin_otp_required', true)->withErrors(['otp' => 'OTP expired. Please try again.']);
        }
        if ((string)$inputOtp !== (string)$storedOtp) {
            return redirect()->back()->with('admin_otp_required', true)->withErrors(['otp' => 'Invalid OTP.']);
        }
        session(['admin_otp_verified' => true]);
        session()->forget(['admin_otp', 'admin_otp_generated_at', 'admin_otp_required']);
        return redirect()->route('admin.whatsapp.group.show');
    }
}
