<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Gallery;
use App\Models\Property;
use Illuminate\Http\Request;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver as GdDriver;
use Illuminate\Support\Facades\Storage;

class GalleryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function show()
    {
        $data[0] = 0;
        $id = $_GET['id'];
        $property = Property::findOrFail($id);
        if (count($property->galleries)) {
            $data[0] = 1;
            $data[1] = $property->galleries;
        }
        return response()->json($data);
    }

    public function getDeletedImages(Request $request)
    {
        $propertyId = $request->get('id');
        $property = Property::findOrFail($propertyId);

        $deletedGalleries = $property->galleries()->onlyTrashed()->get();

        return response()->json([
            'success' => true,
            'deleted_images' => $deletedGalleries
        ]);
        
        $propertyId = $request->get('id');
        $property = Property::findOrFail($propertyId);
        $deletedGalleries = $property->galleries()->onlyTrashed()->get();
    
        $view = view('admin.properties.create-step-4', ['deleted_images' => $deletedGalleries])->render();
    
        return response()->json([
            'success' => true,
            'html' => $view
        ]);
    }
    public function restore($id)
    {
        // dd('hello images id is : '.$id);
        $image = Gallery::onlyTrashed()->findOrFail($id);
        $image->restore();
        return back()->with('success', 'Image restored successfully.');
    }
    
    public function forceDelete($id)
    {
        $image = Gallery::onlyTrashed()->findOrFail($id);
        $image->forceDelete();
    
        return back()->with('success', 'Image deleted permanently.');
    }

    public function store(Request $request)
    {
        $data = [];
        $lastid = $request->property_id;

        if ($files = $request->file('gallery')) {
            // GD driver ke saath ImageManager instance
            $manager = new ImageManager(new GdDriver());

            // **Final canvas size (fixed)**
            $fixedWidth = 640;
            $fixedHeight = 420;

            // **Project directory ke bahar path define karo**
            $outsidePath = base_path('../assets/images/'); // Change "outside_images" to your desired folder

            // **Ensure directory exists**
            if (!file_exists($outsidePath)) {
                mkdir($outsidePath, 0777, true);
            }

            foreach ($files as $key => $file) {
                $val = $file->getClientOriginalExtension();

                if (in_array($val, ['jpeg', 'jpg', 'png', 'svg'])) {
                    $gallery = new Gallery();
                    $filename = time() . '_' . $file->getClientOriginalName();
                    $filePath = $outsidePath . $filename; // Project ke bahar full path

                    // **Original image load karo**
                    $original = $manager->read(file_get_contents($file->getPathname()));

                    // **STEP 1: Resize with aspect ratio**
                    $originalAspectRatio = $original->width() / $original->height();

                    if ($original->height() > $original->width()) {
                        // **Portrait image** → Fix height = 420px, auto width
                        $newHeight = 420;
                        $newWidth = intval($fixedHeight * $originalAspectRatio);
                    } else {
                        // **Landscape image** → Fix width = 640px, auto height
                        $newHeight = 420;
                        $newWidth = intval(420 * $originalAspectRatio);
                    }

                    // Resize image with correct aspect ratio
                    $resizedOriginal = $original->resize($newWidth, $newHeight, function ($constraint) {
                        $constraint->aspectRatio();
                        $constraint->upsize();
                    });

                    // **STEP 2: Blurred Background if Needed**
                    if ($newWidth < $fixedWidth || $newHeight < $fixedHeight) {
                        // **Blurred background create karo**
                        $blurredBg = clone $original;
                        $blurredBg = $blurredBg->resize($fixedWidth, $fixedHeight)->blur(50); // Full blur background

                        // **Blank canvas create karo**
                        $canvas = $manager->create($fixedWidth, $fixedHeight, '#000000');

                        // **Blurred background ko canvas pe lagao**
                        $canvas->place($blurredBg, 'center');

                        // **Resized image ko center me lagao**
                        $canvas->place($resizedOriginal, 'center');

                        $finalImage = $canvas;
                    } else {
                        // **No need for background blur, directly use resized image**
                        $finalImage = $resizedOriginal;
                    }

                    // **STEP 3: Save final image in project ke bahar folder**
                    file_put_contents($filePath, (string) $finalImage->toJpeg());

                    // **Save to database**
                    $gallery['photo'] = $filename;
                    $gallery['property_id'] = $lastid;
                    $gallery->save();

                    $data[] = $gallery;
                }
            }
        }

        return response()->json($data);
    }

    public function destroy()
    {
        $id = $_GET['id'];
        $gal = Gallery::findOrFail($id);
        $gal->delete(); // Soft delete (sets deleted_at)

    }
    public function permanentDelete()
    {
        $id = $_GET['id'];
        $gal = Gallery::withTrashed()->findOrFail($id); // Include soft-deleted

        @unlink('assets/images/' . $gal->photo);

        $gal->forceDelete();

        return response()->json(['message' => 'Image permanently deleted successfully']);
        
    }
   
}
