<?php

namespace App\Http\Controllers\Admin;

use Log;
use Artisan;
use Purifier;
use Throwable;
use Carbon\Carbon;
use App\Models\Currency;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Generalsetting;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Validator;

class GeneralSettingController extends Controller
{

    protected $rules =
    [
        'logo'              => 'mimes:jpeg,jpg,png,svg',
        'favicon'           => 'mimes:jpeg,jpg,png,svg',
        'loader'            => 'mimes:gif',
        'admin_loader'      => 'mimes:gif',
        'affilate_banner'   => 'mimes:jpeg,jpg,png,svg',
        'error_banner'      => 'mimes:jpeg,jpg,png,svg',
        'popup_background'  => 'mimes:jpeg,jpg,png,svg',
        'invoice_logo'      => 'mimes:jpeg,jpg,png,svg',
        'breadcumb_banner'  => 'mimes:jpeg,jpg,png,svg',
        'footer_logo'       => 'mimes:jpeg,jpg,png,svg',
        'cert_sign'         => 'mimes:jpeg,jpg,png,svg',
        'footer'            => 'min:10',
        'copyright'         => 'min:10',
    ];

    public function __construct()
    {
        $this->middleware('auth:admin');
    }
    public function generalupdate(Request $request)
    {
        // dd($request);
        $validator = Validator::make($request->all(), $this->rules);

        if ($validator->fails()) {
            return response()->json(array('errors' => $validator->getMessageBag()->toArray()));
        } else {
            $input = $request->all();
            $data = Generalsetting::findOrFail(1);
            $prev = $data->time_zone;

            if (isset($input['menu'])) {
                $input['menu'] =  $this->setMenu($input);
            }

            if ($file = $request->file('logo')) {
                $name = fileName($file);
                upload($name, $file, $data->logo);
                $input['logo'] = $name;
            }
            if ($file = $request->file('favicon')) {
                $name = fileName($file);
                upload($name, $file, $data->favicon);
                $input['favicon'] = $name;
            }
            if ($file = $request->file('loader')) {
                $name = fileName($file);
                upload($name, $file, $data->loader);
                $input['loader'] = $name;
            }
            if ($file = $request->file('admin_loader')) {
                $name = fileName($file);
                upload($name, $file, $data->admin_loader);
                $input['admin_loader'] = $name;
            }

            if ($file = $request->file('error_photo')) {
                $name = fileName($file);
                upload($name, $file, $data->error_photo);
                $input['error_photo'] = $name;
            }

            if ($file = $request->file('breadcumb_banner')) {
                $name = fileName($file);
                upload($name, $file, $data->breadcumb_banner);
                $input['breadcumb_banner'] = $name;
            }

            if ($file = $request->file('footer_logo')) {
                $name = fileName($file);
                upload($name, $file, $data->footer_logo);
                $input['footer_logo'] = $name;
            }

            if ($request->copyright) {
                $input['copyright'] = Purifier::clean($request->copyright);
            }

            if ($request->error_text) {
                $input['error_text'] = Purifier::clean($request->error_text);
            }

            if ($request->maintain_text) {
                $input['maintain_text'] = Purifier::clean($request->maintain_text);
            }

            if ($request->nexmo_status == 1) {
                $input['nexmo_status'] = 1;
                $input['twilio_status'] = 0;
                $input['infra_status'] = 0;
            } else {
                $input['nexmo_status'] = 0;
                $input['twilio_status'] = 0;
                $input['infra_status'] = 1;
            }

            if ($request->twilio_status == 1) {
                $input['twilio_status'] = 1;
                $input['nexmo_status'] = 0;
                $input['infra_status'] = 0;
            }
            if ($request->infra_status == 1) {
                $input['infra_status'] = 1;
                $input['twilio_status'] = 0;
                $input['nexmo_status'] = 0;
            }

            $this->emailConfig($input);

            $data->update($input);

            try {
                $this->setEnv('APP_TIMEZONE', $input['time_zone']);
            } catch (\Throwable $th) {
                // dd($th->getMessage());
            }

            if ($request->ajax()) {
                $msg = 'Data Updated Successfully.';
                return response()->json($msg);
            } else {
                return back()->withSuccess('Data Updated Successfully.');
            }
        }
    }
    public function whatsapp(Request $request)
    {

        $rules = [
            'whatsapp_api_url' => 'required|url',
            'whatsapp_accessToken' => 'required|string',
            'whatsapp_channelId' => 'required|string|min:10',
            'whatsapp_status' => 'nullable|in:0,1'
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->getMessageBag()->toArray()]);
        }

        $input = $request->all();

        $data = Generalsetting::findOrFail(1);

        $input['whatsapp_status'] = $request->has('whatsapp_status') ? 1 : 0;

        $this->whatsappConfig($input);

        $data->update([
            'whatsapp_api_url' => $input['whatsapp_api_url'],
            'whatsapp_accessToken' => $input['whatsapp_accessToken'],
            'whatsapp_channelId' => $input['whatsapp_channelId'],
            'whatsapp_status' => $input['whatsapp_status']
        ]);
        $msg = 'WhatsApp Configuration Updated Successfully.';

        return $request->ajax()
            ? response()->json($msg)
            : back()->withSuccess($msg);
    }

    public function whatsappConfig($input)
    {
        try {
            $envUpdates = [
                'WHATSAPP_API_ENABLED' => $input['whatsapp_status'] ? 'true' : 'false',
                'WHATSAPP_API_URL' => $input['whatsapp_api_url'],
                'WHATSAPP_API_KEY' => $input['whatsapp_accessToken'],
                'WHATSAPP_CHANNEL_ID' => $input['whatsapp_channelId'] // fixed spelling
            ];


            foreach ($envUpdates as $key => $value) {
                $this->setEnv($key, $value);
            }

            Artisan::call('config:clear');
        } catch (Throwable $e) {
            Log::error('WhatsApp config update failed: ' . $e->getMessage());
            throw $e;
        }
    }

    public function setMenu($input)
    {
        unset($input['menu']);
        unset($input['_token']);
        return json_encode($input);
    }

    public function logo()
    {
        return view('admin.generalsetting.logo');
    }

    public function breadcumb()
    {
        return view('admin.generalsetting.breadcumb');
    }

    public function userimage()
    {
        return view('admin.generalsetting.user_image');
    }

    public function fav()
    {
        return view('admin.generalsetting.favicon');
    }

    public function load()
    {
        return view('admin.generalsetting.loader');
    }

    public function contents()
    {
        return view('admin.generalsetting.websitecontent');
    }


    public function footer()
    {
        return view('admin.generalsetting.footer');
    }

    public function menubuilder()
    {
        return view('admin.menubuilder.index');
    }

    public function cookie()
    {
        return view('admin.generalsetting.cookie');
    }

    public function customcss()
    {
        $file = 'assets/front/css/custom.css';

        if (!file_exists($file)) {
            fopen($file, "w+")
                or die("Unable to open file!");
        }
        $data = file_get_contents($file);

        return view('admin.generalsetting.css', compact('data'));
    }

    public function customcssSubmit(Request $request)
    {
        $file = 'assets/front/css/custom.css';

        if (!file_exists($file)) {
            fopen($file, "w+")
                or die("Unable to open file!");
        }

        file_put_contents($file, $request->custom_css);

        $msg = 'Data Updated Successfully.';
        return response()->json($msg);
    }

    public function paymentsinfo()
    {
        $curr = Currency::where('is_default', '=', 1)->first();
        return view('admin.generalsetting.paymentsinfo', compact('curr'));
    }

    public function affilate()
    {
        return view('admin.generalsetting.affilate');
    }

    public function errorbanner()
    {
        return view('admin.generalsetting.error_banner');
    }

    public function maintain()
    {
        return view('admin.generalsetting.maintain');
    }

    public function twilio()
    {
        return view('admin.sms.twilio');
    }

    public function nexmo()
    {
        return view('admin.sms.nexmo');
    }
    public function infra()
    {
        return view('admin.sms.infra');
    }

    public function status($field, $value)
    {
        $prev = '';
        $data = Generalsetting::find(1);
        if ($field == 'is_debug') {
            $prev = $data->is_debug == 1 ? 'true' : 'false';
        }
        $data[$field] = $value;
        $data->update();
        if ($field == 'is_debug') {
            $now = $data->is_debug == 1 ? 'true' : 'false';
            $this->setEnv('APP_DEBUG', $now, $prev);
        }
        //--- Redirect Section
        $msg = __('Status Updated Successfully.');
        return response()->json($msg);
        //--- Redirect Section Ends

    }

    public function emailConfig($input)
    {

        try {
            $this->setEnv('MAIL_HOST', $input['smtp_host']);
            $this->setEnv('MAIL_PORT', $input['smtp_port']);
            $this->setEnv('MAIL_USERNAME', $input['smtp_user']);
            $this->setEnv('MAIL_PASSWORD', $input['smtp_pass']);
            $this->setEnv('MAIL_ENCRYPTION', 'tls');
            if (isset($input['molly_key'])) {
                $this->setEnv('MOLLIE_KEY', $input['molly_key']);
            }
        } catch (\Throwable $e) {
        }
    }

    private function setEnv($key, $value)
    {
        file_put_contents(app()->environmentFilePath(), str_replace(
            $key . '=' . env($key),
            $key . '=' . $value,
            file_get_contents(app()->environmentFilePath())
        ));
    }

    public function default()
    {
        return view('admin.generalsetting.default-settings');
    }
}
