<?php

namespace App\Http\Controllers\Admin;

use App\Classes\GeniusMailer;
use App\Models\Plan;
use Datatables;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\Follow;
use App\Models\Generalsetting;
use App\Models\Transaction;
use App\Models\User;
use App\Models\Property;
use App\Models\PropertyEnquiry;
use App\Models\Withdraw;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class LeadsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }
    public function datatables(Request $request)
    {
        $datas = User::withCount(['enquiries', 'properties as properties_count' => function ($query) {
            $query->where('status', 1); 
        }])
            ->whereNull('plan_id')
            ->whereHas('properties', function ($query) {
                $query->where('status', 1) 
              ->has('enquiries', '>', 3);
            })
            ->orderBy('id', 'desc');

        if ($request->filled('from_date') && $request->filled('to_date')) {
            $from = Carbon::parse($request->from_date)->startOfDay();
            $to = Carbon::parse($request->to_date)->endOfDay();
            $datas->whereBetween('created_at', [$from, $to]);
        }

        if ($request->filled('user_type')) {
            $datas->where('user_type', $request->user_type);
        } else {
            $datas->whereNotIn('user_type', ['user', 'tenant']);
        }

        if ($request->filled('enquiry_count')) {
            $upper = (int) $request->enquiry_count;

            // Round down to nearest multiple of 5
            $lower = $upper - ($upper % 5);

            // If upper is already a multiple of 5 (e.g. 10, 45), go back one block
            if ($upper % 5 === 0 && $upper !== 0) {
                $lower = $upper - 5;
            }

            $datas->havingBetween('enquiries_count', [$lower, $upper]);
        } else {
            $datas->having('enquiries_count', '>', 3);
        }

        return Datatables::of($datas)
            ->addColumn('action', function (User $data) {
                return '<div class="btn-group mb-1">
                <button type="button" class="btn btn-primary btn-sm btn-rounded dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                Actions
                </button>
                <div class="dropdown-menu" x-placement="bottom-start">
                    <a href="' . route('admin-user-show', $data->id) . '"  class="dropdown-item">Details</a>
                    <a href="' . route('admin-user-edit', $data->id) . '" class="dropdown-item">Edit</a>
                    <a href="javascript:;" class="dropdown-item send" data-email="' . $data->email . '" data-toggle="modal" data-target="#vendorform">Send</a>
                </div>
            </div>';
            })
            ->addColumn('status', function (User $data) {
                $status = $data->is_banned == 1 ? __('Block') : __('Unblock');
                $status_sign = $data->is_banned == 1 ? 'danger' : 'success';

                return '<div class="btn-group mb-1">
                <button type="button" class="btn btn-' . $status_sign . ' btn-sm btn-rounded dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    ' . $status . '
                </button>
                <div class="dropdown-menu" x-placement="bottom-start">
                    <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="' . route('admin-user-ban', ['id1' => $data->id, 'id2' => 0]) . '">Unblock</a>
                    <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="' . route('admin-user-ban', ['id1' => $data->id, 'id2' => 1]) . '">Block</a>
                </div>
            </div>';
            })
            ->rawColumns(['action', 'status'])
            ->toJson();
    }

    public function index()
    {
        return view('admin.sale.index');
    }
    public function datatables1($id)
    {
        $properties = Property::withCount('enquiries')
            ->with(['enquiries.user'])
            ->where('user_id', $id)
            ->where('status', 1)
            ->whereHas('user', function ($uq) {
                $uq->whereNull('plan_id');
            })
            ->orderByDesc('updated_at');

        return DataTables::of($properties)
            ->addIndexColumn()
            ->editColumn('created_at', fn($property) => $property->created_at->format('d-m-Y'))
            ->addColumn('enquiries_count', fn($property) => $property->enquiries_count)
            ->addColumn('view_btn', function (Property $property) {
                $routes = [
                    'for_pg' => 'pg.details',
                    'for_rent' => 'rent.details',
                    'for_sell' => 'buy.details',
                    'plot' => 'plot.details',
                    'commercial' => 'commercial.details',
                ];

                $propertyUrl = $routes[$property->looking_for] ?? '#';

                return '<div><a class="" href="'
                    . route($propertyUrl, $property->slug ?? '')
                    . '" target="_blank">View Property</a></div>';
            })
            ->addColumn('name_with_status', function (Property $property) {
                $is_paid = $property->is_primium == 1
                    ? ' (<span class="text-success">' . __('(Paid') . '</span>)'
                    : ' (<span class="text-danger">' . __('Unpaid') . '</span>)';

                $name = $property->name ?? 'N/A';

                return '<div class="btn-group mb-1">'
                    . ucwords($name) . ' ' . $is_paid . '
            </div>';
            })

            ->rawColumns(['view_btn', 'name_with_status'])
            ->make(true);
    }


    public function properties($id)
    {
        $user = User::with('properties')->findOrFail($id);

        $properties = Property::where('user_id', $id)->paginate(10);

        return view('admin.sale.leads.index', compact('id', 'properties'));
    }
}
