<?php

namespace App\Http\Controllers\Admin;

use Datatables;
use App\Models\City;
use App\Models\State;
use App\Models\Country;
use App\Models\Location;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class LocationController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:admin');
    }

    public function datatables(Request $request)
    {
        $datas = Location::orderByRaw('IF(custom_order IS NULL, 1, 0), custom_order ASC');

        //  $datas = Location::with('country')->orderBy('id', 'desc')->get();

         return Datatables::of($datas)
                        ->addColumn('checkbox',function(Location $data){
                            return $checkbox = $data->id ? '<input type="checkbox" class="form-check-input m-0 p-0 columnCheck" value="'.$data->id.'">':'';
                        })
                        ->editColumn('created_at', function(Location $data){
                            return $data->created_at->toFormattedDateString();
                        })
                        ->editColumn('name', function(Location $data){
                            return $data = $data->parent_id != NULL ? $data->name.', '.$data->parent->name : $data->name;
                        })
                        ->addColumn('status', function(Location $data) {
                            $status      = $data->status == 1 ? __('Activated') : __('Deactivated');
                            $status_sign = $data->status == 1 ? 'success'   : 'danger';

                            return '<div class="btn-group mb-1">
                                        <button type="button" class="btn btn-'.$status_sign.' btn-sm btn-rounded dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        '.$status .'
                                        </button>
                                        <div class="dropdown-menu" x-placement="bottom-start">
                                            <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'. route('admin.locations.status',['id1' => $data->id, 'id2' => 1]).'">'.__("Activate").'</a>
                                            <a href="javascript:;" data-toggle="modal" data-target="#statusModal" class="dropdown-item" data-href="'. route('admin.locations.status',['id1' => $data->id, 'id2' => 0]).'">'.__("Deactivate").'</a>
                                        </div>
                                    </div>';
                        })
                        ->addColumn('action', function(Location $data) {
                              return '<div class="btn-group mb-1">
                                <button type="button" class="btn btn-primary btn-sm btn-rounded dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                  '.'Actions' .'
                                </button>
                                <div class="dropdown-menu" x-placement="bottom-start">
                                  <a href="' . route('admin.locations.edit',$data->id) . '"  class="dropdown-item">'.__("Edit").'</a>
                                  <a href="javascript:;" data-toggle="modal" data-target="#deleteModal" class="dropdown-item" data-href="'.  route('admin.locations.delete',$data->id).'">'.__("Delete").'</a>
                                </div>
                              </div>';
                        })
                        ->rawColumns(['checkbox','photo','status','action'])
                        ->toJson();
    }

    public function index(){
        return view('admin.locations.index');
    }

    public function create(){
        $data['countries'] = Country::get();
        $data['states'] = State::with('country')->get();
        $data['locations'] = Location::whereStatus(1)->get();
        return view('admin.locations.create',$data);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'country_id' => 'required|exists:countries,id',
            'state_id' => 'required|exists:states,id',
            'city_type' => 'required|in:city,top_city',
            'cities' => 'required|array|min:1',
            'cities.*' => [
                'required',
                'string',
                'max:255',
                'distinct',
                function ($attribute, $value, $fail) use ($request) {
                    $exists = Location::where('name', $value)
                        ->where('state_id', $request->state_id)
                        ->where('country_id', $request->country_id)
                        ->exists();

                    if ($exists) {
                        $fail("The city '$value' already exists for the selected state and country.");
                    }
                },
            ],
        ]);
        $isTopCity = $validated['city_type'] === 'top_city' ? 1 : 0;

        foreach ($validated['cities'] as $cityName) {

            Location::create([
                'name' => $cityName,
                'country_id' => $validated['country_id'],
                'state_id' => $validated['state_id'],
                'is_top_city' => $isTopCity,
                'city' => $cityName,
            ]);
            City::create([
            'name' => $cityName,
            'country_id' => $validated['country_id'],
            'state_id' => $validated['state_id'],
        ]);
        }

        return redirect()->route('admin.locations.index')->with('success', 'Locations and cities added successfully!');
    }

    public function edit($id)
    {
        $location = Location::findOrFail($id);

        $data['countries'] = Country::all();

        $data['states'] = State::get();

        $data['data'] = $location;

        return view('admin.locations.edit', $data);
    }

    public function update(Request $request, $id)
    {
        $validated = $request->validate([
            'country_id' => 'required|exists:countries,id',
            'state_id' => 'required|exists:states,id',
            'city_type' => 'required|in:city,top_city',
            'city' => 'required|string|max:255|unique:locations,name,' . $id . ',id',  // Ensure unique city name excluding the current one
        ]);

        $location = Location::findOrFail($id);

        $isTopCity = $validated['city_type'] === 'top_city' ? 1 : 0;

        // Update the city location
        $location->update([
            'name' => $validated['city'],
            'country_id' => $validated['country_id'],
            'state_id' => $validated['state_id'],
            'is_top_city' => $isTopCity,
            'city' => $validated['city'],
        ]);

        // Redirect with a success message
        return redirect()->route('admin.locations.index')->with('success', 'Location and city updated successfully!');
    }


    public function status($id1,$id2)
    {
        $data = Location::findOrFail($id1);
        $data->status = $id2;
        $data->update();

        $msg = 'Data Updated Successfully.';
        return response()->json($msg);
    }

    public function bulkdelete(Request $request){
        $ids = $request->bulk_id;
        $bulk_ids = explode(",",$ids);
        foreach($bulk_ids as $key=>$id){
            if($id){
                try {
                    $this->delete($id);
                    $msg = 'Data Deleted Successfully.';
                } catch (\Throwable $th) {
                    $msg = 'Something went wrong.';
                }
            }
        }
        return response()->json($msg);
    }

    public function destroy($id)
    {
        try {
            $this->delete($id);
            $msg = 'Data Deleted Successfully.';
        } catch (\Throwable $th) {
            $msg = 'Something went wrong.';
        }
        return response()->json($msg);
    }

    public function delete($id){
        $data = Location::findOrFail($id);
        $data->delete();

        return true;
    }

    public function updateOrder(Request $request)
    {
        $location = Location::find($request->id);
        if ($location) {
            $location->custom_order = $request->custom_order;
            $location->save();

            return response()->json(['success' => true, 'message' => __('Order updated successfully.')]);
        }

        return response()->json(['success' => false, 'message' => __('Location not found.')]);
    }
    public function stateList()
    {
        $data['states'] = State::with('country', 'cities')
                              ->withCount('cities')
                              ->get();

        return view('admin.locations.state-list', $data);
    }

    public function getCitiesForState($stateId)
    {
        $state = State::with('cities')->find($stateId);

        if (!$state) {
            return response()->json(['message' => 'State not found'], 404);
        }
        return response()->json(['cities' => $state->cities]);
    }

    public function addStateform()
    {
        $data['countries'] = Country::get();

        return view('admin.locations.add-state', $data);
    }

    public function addState(Request $request)
    {
        // dd($request);
        $validated = $request->validate([
            'country_id' => 'required|exists:countries,id',
            'states' => 'required|array|min:1',
            'states.*' => 'required|string|max:255|distinct|unique:states,name',
        ]);
        foreach ($validated['states'] as $stateName) {
            State::create([
                'name' => $stateName,
                'country_id' => $validated['country_id'],
            ]);
        }

        return redirect()->back()->with('success', 'States added successfully!');
    }

}
