<?php

namespace App\Http\Controllers\Agent;

use Datatables;
use App\Models\Plan;
use App\Models\User;
use App\Models\Currency;
use App\Models\Property;
use App\Models\PlanHisory;
use Illuminate\Http\Request;
use App\Models\ExpiredUserPackage;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class PlanController extends Controller
{
    public function userAllPackages()
    {
        $userType = Auth::user()->user_type;
        $packages = Plan::where('user_type', $userType)->get();
        return view('agent.plans.packages-all', compact('packages'));
    }
    public function userActivePackages()
    {
        $user = Auth::user();
        $activePlan = null;
        if ($user->plan_id && $user->plan_end_date && now()->lt($user->plan_end_date)) {
            $activePlan = Plan::find($user->plan_id);
            if ($activePlan) {
                $activePlan->expires_at = $user->plan_end_date;
            }
        }
        $availableCredit = $user->ad_limit ?? 0;
        $totalCredit = $activePlan->post_limit ?? 0;
        return view('agent.plans.packages-active', compact('activePlan', 'availableCredit', 'totalCredit'));
    }
    public function inactiveListings($user_id = null)
    {
        $user = $user_id ? User::findOrFail($user_id) : Auth::user();
        $availableCredit = $user->ad_limit ?? 0;
        $expiredProperties = Property::where('user_id', $user->id)
            ->where('status', 1)
            ->where('is_primium', 2)
            ->orderBy('id', 'desc')
            ->get();
        return view('agent.plans.in-active-listings', compact('expiredProperties', 'availableCredit'));
    }
    public function activeListings($user_id = null)
    {
        $user = $user_id ? User::findOrFail($user_id) : Auth::user();
        $expiredProperties = Property::whereUserId($user->id)
            ->where('is_primium', 1)
            ->orderBy('id', 'desc')
            ->get();
        return view('agent.plans.active-listings', compact('expiredProperties'));
    }
    public function expiredPackages($user_id = null)
    {
        $user = $user_id ? User::find($user_id) : Auth::user();
        $expiredPackages = PlanHisory::with('plan')->where('user_id', $user->id)
            ->where(function ($q) {
                $q->where('status', 0);
            })
            ->get();
        return view('agent.plans.packages-expired', compact('expiredPackages'));
    }
}
