<?php

namespace App\Http\Controllers\Agent;

use Session;
use Validator;
use App\Models\User;
use App\Models\Country;
use App\Models\BankPlan;
use App\Models\Transaction;
use Illuminate\Support\Str;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Classes\GeniusMailer;
use App\Models\ReferralBonus;
use App\Models\Generalsetting;
use Illuminate\Support\Carbon;
use App\Models\UserSubscription;
use App\Services\SendSmsService;
use App\Services\WhatsAppService;
use PHPMailer\PHPMailer\PHPMailer;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;

class RegisterController extends Controller
{
    // protected $sendsmservice;
    // protected $whatsappservice;

    public function __construct(protected SendSmsService $sendsmservice, protected WhatsAppService $whatsappservice)
    {
        // $this->sendsmservice = $sendsmservice;
        // $this->whatsappservice = $whatsappservice;
        $this->middleware('guest');
    }

    public function otpForm()
    {
        return view('agent.send-otp');
    }

    public function emailForm()
    {
        return view('agent.by-email');
    }

    public function emailSubmit(Request $request)
    {
        $request->validate([
            'email' => 'required|email|max:255',
        ]);

        $existingUser = User::where('email', $request->email)->first();

        if ($existingUser) {
            session(['email' => $request->email]);
            $is_agent = $existingUser->is_agent;
            if ($is_agent != 2) {
                session()->forget('phone');
                session()->forget('email');
                return redirect()->back()->with('error', 'This email is already registered as a customer. Please log in at <a style ="color:blue"  href="' . route('user.otp') . '" target="_blank">Customer Login</a> or use a different email to post a property.');
            } else {
                return redirect()->route('agent.login-with-password');
            }
        } else {
            session(['email' => $request->email]);
            return redirect()->route('agent.register-step-2');
        }
    }

    public function passwordForm(Request $request)
    {
        return view('agent.email-password');
    }

    public function passwordSubmit(Request $request)
    {
        $request->validate([
            'password' => 'required',
        ]);

        $email = session('email');

        if (!$email) {
            return redirect()->back()->withErrors(['email' => 'Email session expired. Please try again.']);
        }
        if (Auth::guard('web')->attempt(['email' => $email, 'password' => $request->password])) {
            session()->forget('email');

            return $this->redirectToDashboard(Auth::user());
        } else {
            return redirect()->back()->withErrors(['password' => 'Invalid email or password.']);
        }
    }
    public function sendOtp(Request $request)
    {
        $request->validate([
            'phone' => 'required|numeric|min:10',
        ]);

        try {
            $otp = rand(1000, 9999);
            $phone = $request->input('phone');
            session([
                'phone' => $phone,
                'otp' => $otp,
                'otp_generated_at' => now(),
            ]);

            $serviceName = 'OTP service';
            $sendsmsResponse = $this->sendsmservice->sendOTPSMS($phone, $otp, $serviceName);

            info("SMS Test", ['data' => $sendsmsResponse]);
            \Log::info('Otp message response: ' . json_encode($sendsmsResponse));

            return redirect()->route('agent.verify.otp')->with('success', 'OTP sent successfully.');
        } catch (\Exception $e) {
            \Log::error('Error sending OTP: ' . $e->getMessage());
            return redirect()->back()->with('error', 'An error occurred while processing your request.');
        }
    }

    public function verifyOtpform(Request $request)
    {
        if (!session('otp')) {
            return redirect('/');
        }
        return view('agent.verify-otp');
    }

    public function verifyOtp(Request $request)
    {
        $request->validate([
            'otp' => 'nullable|digits:4',
            'password' => 'nullable|min:6',
        ]);

        $inputOtp = trim($request->input('otp'));
        $inputPassword = $request->input('password');
        $storedOtp = session('otp');
        $otpGeneratedAt = session('otp_generated_at');
        $phone = session('phone');

        if (!$phone) {
            return redirect()->back()->with('error', 'Session expired. Please start the process again.');
        }

        $existingUser = User::where('phone', $phone)->first();

        if ($inputOtp) {
            if (!$storedOtp || !$otpGeneratedAt || now()->diffInSeconds(date: $otpGeneratedAt) > 90) {
                return redirect()->back()->with('error', 'OTP expired. Please regenerate.');
            }

            if ((string)$inputOtp !== (string)$storedOtp) {
                return redirect()->back()->with('error', 'Invalid OTP.');
            }

            session()->forget(['otp', 'otp_generated_at']);

            if ($existingUser) {
                Auth::login($existingUser);
                return $this->redirectToDashboard($existingUser);
            }

            return redirect()
                ->route('user.register-step-2')
                ->with('success', 'Phone number verified. Proceed to complete registration.');
        }

        if ($inputPassword && $existingUser) {
            if (Auth::attempt(['phone' => $phone, 'password' => $inputPassword])) {
                session()->forget(['otp', 'otp_generated_at']);
                return $this->redirectToDashboard($existingUser);
            } else {
                return redirect()->back()->with('error', 'Invalid password.');
            }
        }

        return redirect()->back()->with('error', 'Please provide either a valid OTP or password.');
    }

    private function redirectToDashboard($user)
    {
        if ($user->user_type === 'agent' || $user->user_type === 'owner' || $user->user_type === 'builder/developer') {
            return redirect()->route('agent.dashboard')->with('success', 'Logged in successfully.');
        }
        return redirect()->route('user.dashboard')->with('success', 'Logged in successfully.');
    }

    public function regenerateOtp()
    {
        $phone = session('phone');

        if (!$phone) {
            return redirect()->back()->with('error', 'Phone number not found. Please try again.');
        }

        $otpGeneratedAt = session('otp_generated_at');

        if (now()->diffInSeconds($otpGeneratedAt) < 300) {
            return redirect()->back()->with('error', 'You can regenerate OTP after 1 minute.');
        }

        try {
            $otp = rand(1000, 9999);
            session([
                'otp' => $otp,
                'otp_generated_at' => now(),
            ]);
            $serviceName = 'OTP service';
            $sendsmsResponse = $this->sendsmservice->sendOTPSMS($phone, $otp, $serviceName);

            info("Regenerated OTP Test", ['data' => $sendsmsResponse]);
            \Log::info('Regenerated Otp message response: ' . json_encode($sendsmsResponse));

            return redirect()->back()->with('success', 'New OTP sent successfully.');
        } catch (\Exception $e) {
            \Log::error('Error regenerating OTP: ' . $e->getMessage());
            return redirect()->back()->with('error', 'An error occurred while regenerating the OTP.');
        }
    }

    public function showRegister()
    {
        return view('agent.becomeagent');
    }

    public function register(Request $request)
    {
        $hasEmailInSession = session('email');
        $hasPhoneInSession = session('phone');
        $request->validate([
            'name' => 'required|max:255',
            'phone' => [
                $hasPhoneInSession ? 'nullable' : 'required',
                'unique:users,phone'
            ],
            'email' => [
                $hasEmailInSession ? 'nullable' : 'required',
                'email',
                'max:255',
                'unique:users'
            ],
            'user_type' => 'required',
            'password' => 'required'
        ]);

        $gs = Generalsetting::findOrFail(1);

        $phone = $request['phone'] ?? session('phone');
        $email = $request['email'] ?? session('email');

        $user = new User;
        $input = $request->all();

        $input['password'] = bcrypt($request['password']);
        $token = md5(time() . $request->name . $request->email);
        $input['verification_link'] = $token;
        $input['affilate_code'] = md5($request->name . $request->email);
        $input['status'] = 0;
        $input['is_agent'] = 2;
        // temporary code for bypassing subscription plans
        // $user->plan_id = 1;
        // $user->ad_limit = 5;
        $user->user_type = $request['user_type'];
        $user->phone = $phone;
        $user->email = $email;
        $user->username = $phone;
        $user->fill($input)->save();

        if ($gs->is_verification_email == 1) {
            $verificationLink = "<a href=" . url('user/register/verify/' . $token) . ">Simply click here to verify. </a>";
            $to = $request->email;
            $subject = 'Verify your email address.';
            $msg = "Dear Customer,<br> We noticed that you need to verify your email address." . $verificationLink;

            if ($gs->is_smtp == 1) {
                $mail = new PHPMailer(true);
                try {
                    $mail->isSMTP();
                    $mail->Host = $gs->smtp_host;
                    $mail->SMTPAuth = true;
                    $mail->Username = $gs->smtp_user;
                    $mail->Password = $gs->smtp_pass;
                    if ($gs->smtp_encryption == 'ssl') {
                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
                    } else {
                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                    }
                    $mail->Port = $gs->smtp_port;
                    $mail->CharSet = 'UTF-8';
                    $mail->setFrom($gs->from_email, $gs->from_name);
                    $mail->addAddress($email, $user->name);
                    $mail->addReplyTo($gs->from_email, $gs->from_name);
                    $mail->isHTML(true);
                    $mail->Subject = $subject;
                    $mail->Body = $msg;
                    $mail->send();
                } catch (Exception $e) {
                }
            } else {
                $headers = "From: " . $gs->from_name . "<" . $gs->from_email . ">";
                mail($to, $subject, $msg, $headers);
            }
            return response()->json('We need to verify your email address. We have sent an email to ' . $to . ' to verify your email address. Please click link in that email to continue.');
        } else {
            if (Session::has('affilate')) {
                $referral = User::findOrFail(Session::get('affilate'));
                $user->referral_id = $referral->id;
                $user->update();
            }
            if ($gs->is_affilate == 1) {
                if (Session::has('affilate')) {

                    $mainUser = User::findOrFail(Session::get('affilate'));
                    $mainUser->balance += $gs->affilate_user;
                    $mainUser->update();

                    $user->balance += $gs->affilate_new_user;
                    $user->update();

                    $bonus = new ReferralBonus();
                    $bonus->from_user_id = $user->id;
                    $bonus->to_user_id = $mainUser->id;
                    $bonus->amount = $gs->affilate_user;
                    $bonus->type = 'Register';
                    $bonus->save();

                    $mainUserTrans = new Transaction();
                    $mainUserTrans->email = $mainUser->email;
                    $mainUserTrans->amount = $gs->affilate_user;
                    $mainUserTrans->type = "Referral Bonus";
                    $mainUserTrans->profit = "plus";
                    $mainUserTrans->txnid = Str::random(12);
                    $mainUserTrans->user_id = $mainUser->id;
                    $mainUserTrans->save();

                    $newUserTrans = new Transaction();
                    $newUserTrans->email = $email;
                    $newUserTrans->amount = $gs->affilate_user;
                    $newUserTrans->type = "Referral Bonus";
                    $newUserTrans->profit = "plus";
                    $newUserTrans->txnid = Str::random(12);
                    $newUserTrans->user_id = $user->id;
                    $newUserTrans->save();
                }
            }
            $user->email_verified = 'Yes';
            $user->update();
            if ($gs->is_smtp == 1) {
                $data = [
                    'to' => $user->email ?? session('email'),
                    'type' => "welcome",
                    'cname' => $user->name,
                    'oamount' => "",
                    'aname' => "",
                    'aemail' => "",
                    'wtitle' => "",
                ];
                $mailer = new GeniusMailer();
                $mailer->sendAutoMail($data);
            } else {
                $to = $user->email ?? session('email');
                $subject = "Welcome to our website";
                $msg = "Hello " . $user->name . "!\nYour registration successfully completed.\nThank you.";
                $headers = "From: " . $gs->from_name . "<" . $gs->from_email . ">";
                mail($to, $subject, $msg, $headers);
            }
            Auth::guard('web')->login($user);

            $this->sendsmservice->sendSignupSMS($phone, $request->name, $request->email ?? session('email'), $request->password);
            $phone = '91' . $phone;
            $templateName = 'greetings';
            $headerImageUrl = 'http://wbbox.in/WpSmsCampFiles/940/Application_Files/MediaUploads/no2nJlUR1733749349.jpeg';

            $response = $this->whatsappservice->sendMessageWithTemplate($phone, $templateName, $headerImageUrl);
            session()->forget('phone');
            session()->forget('email');
            return redirect()->route('agent.dashboard');
        }
    }

    public function token($token)
    {
        $gs = Generalsetting::findOrFail(1);
        if ($gs->is_verification_email == 1) {
            $user = User::where('verification_link', '=', $token)->first();
            if (isset($user)) {
                $user->email_verified = 'Yes';
                $user->update();

                if (Session::has('affilate')) {
                    $referral = User::findOrFail(Session::get('affilate'));
                    $user->referral_id = $referral->id;
                    $user->update();
                }

                if ($gs->is_affilate == 1 && Session::has('affilate')) {
                    $mainUser = $referral;
                    $mainUser->balance += $gs->affilate_user;
                    $mainUser->update();

                    $user->balance += $gs->affilate_new_user;
                    $user->update();
                }


                $notification = new Notification;
                $notification->user_id = $user->id;
                $notification->save();

                if ($gs->is_smtp == 1) {
                    $data = [
                        'to' => $email,
                        'type' => "welcome",
                        'cname' => $user->name,
                        'oamount' => "",
                        'aname' => "",
                        'aemail' => "",
                        'wtitle' => "",
                    ];

                    $mailer = new GeniusMailer();
                    $mailer->sendAutoMail($data);
                } else {
                    $to = $email;
                    $subject = "Welcome to our website";
                    $msg = "Hello " . $user->name . "!\nYour registration successfully completed.\nThank you.";
                    $headers = "From: " . $gs->from_name . "<" . $gs->from_email . ">";
                    mail($to, $subject, $msg, $headers);
                }

                Auth::guard('web')->login($user);
                return redirect()->route('agent.dashboard')->with('success', 'Email Verified Successfully');
            }
        } else {
            return redirect()->back();
        }
    }
}
