<?php

namespace App\Http\Controllers\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Auth\Events\Verified;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;
use App\Models\User;

class VerifyEmailController extends Controller
{
    public function verify(Request $request)
    {
        $user = User::findOrFail($request->route('id'));

        // Validate the signature hash manually
        if (!hash_equals((string) $request->route('hash'), sha1($user->getEmailForVerification()))) {
            abort(403, 'Invalid verification link.');
        }

        // Login the user (optional, but useful for auto-login after verify)
        Auth::login($user);

        if ($user->hasVerifiedEmail()) {
            return redirect()->route('user.dashboard')->with('verified', true);
        }

        $user->markEmailAsVerified();
        event(new Verified($user));

        return redirect()->route('user.dashboard')->with('verified', true);
    }
}
