<?php

namespace App\Http\Controllers\Checkout;

use App\Http\Controllers\Controller;
use App\Models\BuyRent;
use App\Models\Currency;
use App\Models\Generalsetting;
use App\Models\Order;
use App\Models\PaymentGateway;
use Illuminate\Http\Request;
use Omnipay\Omnipay;
use Illuminate\Support\Facades\Session;
use App\Repositories\OrderRepository;
use Illuminate\Support\Str;

class PaypalController extends Controller
{
    public $orderRepositorty;

    public function __construct(OrderRepository $orderRepositorty)
    {
        $this->orderRepositorty = $orderRepositorty;
    }

    public function store(Request $request)
    {

        $cancel_url = route('checkout.paypal.cancel');
        $notify_url = route('checkout.paypal.notify');

        $item_number = Str::random(4) . time();
        $item_amount = $request->amount;

        $support = ['USD', 'EUR'];
        if (!in_array($request->currency_code, $support)) {
            return redirect()->back()->with('warning', 'Please Select USD Or EUR Currency For Paypal.');
        }


        $currency = Currency::whereId($request->currency_id)->first();

        $data = PaymentGateway::whereKeyword('paypal')->first();
        $paydata = $data->convertAutoData();
        $gateway = Omnipay::create('PayPal_Rest');
        $gateway->setClientId($paydata['client_id']);
        $gateway->setSecret($paydata['client_secret']);
        $gateway->setTestMode(true);

        try {
            $response = $gateway->purchase(array(
                'amount' => $item_amount,
                'currency' => $currency->name,
                'returnUrl' => $notify_url,
                'cancelUrl' => $cancel_url,
            ))->send();
            if ($response->isRedirect()) {
                Session::put('paypal_data', $request->all());
                Session::put('order_number', $item_number);

                if ($response->redirect()) {
                    return redirect($response->redirect());
                }
            } else {
                return redirect()->back()->with('error', $response->getMessage());
            }
        } catch (\Throwable $th) {
            dd($th->getMessage());
            return redirect()->back()->with('error', $th->getMessage());
        }
    }

    public function notify(Request $request)
    {

        $trx = Session::get('order_number');
        $input = (object) Session::get('paypal_data');
        $responseData = $request->all();

        if (empty($responseData['PayerID']) || empty($responseData['token'])) {
            return [
                'status' => false,
                'message' => __('Unknown error occurred'),
            ];
        }

        $data = PaymentGateway::whereKeyword('paypal')->first();
        $paydata = $data->convertAutoData();
        $gateway = Omnipay::create('PayPal_Rest');
        $gateway->setClientId($paydata['client_id']);
        $gateway->setSecret($paydata['client_secret']);
        $gateway->setTestMode(true);
        $transaction = $gateway->completePurchase(array(
            'payer_id' => $responseData['PayerID'],
            'transactionReference' => $responseData['paymentId'],
        ));

        $response = $transaction->send();

        if ($response->isSuccessful()) {

            $buyRent = BuyRent::findOrFail($input->buy_rent_id);

            $data = new Order();
            $data->property_id = $buyRent->property_id;
            $data->user_id = $buyRent->user_id;
            $data->property_owner_id = $buyRent->property_owner_id;
            $data->transaction_no = Str::random(12);
            $data->txnid = $response->getData()['transactions'][0]['related_resources'][0]['sale']['id'];
            $data->charge_id =  $response->getData()['id'];
            $data->amount = $input->amount;
            $data->method = $input->method;
            $data->status = 1;

            $data->save();

            $buyRent->phase = 0;
            $buyRent->status = 1;
            $buyRent->update();


            Session::forget('paypal_data');
            Session::forget('paypal_payment_id');
            Session::forget('order_number');

            return redirect()->route('user.invest.history')->with('message', 'Invest successfully complete.');
        } else {
            return redirect()->route('user.invest.checkout')->with('error', 'Payment not successfully complete.');
        }
    }

    public function cancel()
    {
        return redirect()->route('user.invest.checkout')->with('warning', 'Something went wrong!');
    }
}
