<?php

namespace App\Http\Controllers\Checkout;

use App\Repositories\OrderRepository;
use App\Http\Controllers\Controller;
use App\Models\Generalsetting;
use App\Models\PaymentGateway;
use Illuminate\Http\Request;
use App\Models\BuyRent;
use App\Models\Order;
use Config;
use Exception;
use Illuminate\Support\Facades\Session;

class StripeController extends Controller
{
    public $orderRepositorty;
    public  $allusers = [];

    public function __construct(OrderRepository $orderRepositorty)
    {
        $data = PaymentGateway::whereKeyword('Stripe')->first();
        $paydata = $data->convertAutoData();
        Config::set('services.stripe.key', $paydata['key']);
        Config::set('services.stripe.secret', $paydata['secret']);

        $this->orderRepositorty = $orderRepositorty;
    }

    public function store(Request $request)
    {
    
        $gs = Generalsetting::findOrFail(1);
        $item_name = $gs->title . " Property";

        $item_amount = $request->amount;

        $support = ['USD'];
        if (!in_array($request->currency_code, $support)) {
            return redirect()->back()->with('warning', 'Please Select USD Currency For Stripe.');
        }

        try {
            $stripe_secret_key = Config::get('services.stripe.secret');
            \Stripe\Stripe::setApiKey($stripe_secret_key);
            $checkout_session = \Stripe\Checkout\Session::create([
                "mode" => "payment",
                "success_url" => route('checkout.stripe.notify') . '?session_id={CHECKOUT_SESSION_ID}',
                "cancel_url" => url()->previous(),
                "locale" => "auto",
                "line_items" => [
                    [
                        "quantity" => 1,
                        "price_data" => [
                            "currency" => $request->currency_code,
                            "unit_amount" => $item_amount * 100,
                            "product_data" => [
                                "name" => $item_name
                            ]
                        ]
                    ],

                ]
            ]);

            Session::put('input_data', $request->all());
            return redirect($checkout_session->url);
        } catch (Exception $e) {
            return back()->with('unsuccess', $e->getMessage());
        }
    }


    public function notify(Request $request)
    {
        $input = (object) Session::get('input_data');
        $stripe = new \Stripe\StripeClient(Config::get('services.stripe.secret'));
        $response = $stripe->checkout->sessions->retrieve($request->session_id);

        $buyRent = BuyRent::findOrFail($input->buy_rent_id);
        if ($response->status == 'complete') {

            $data = new Order();
            $data->property_id = $buyRent->property_id;
            $data->user_id = $buyRent->user_id;
            $data->property_owner_id = $buyRent->property_owner_id;
            $data->transaction_no = $buyRent->transaction_no;
            $data->txnid = $response->payment_intent;
            $data->charge_id = $response->id;
            $data->amount = $input->amount;
            $data->method = $input->method;
            $data->status = 1;

            $data->save();

            $buyRent->phase = 0;
            $buyRent->status = 1;
            $buyRent->update();
            return redirect()->route('user.buy.rent.details', $buyRent->id)->with('message', 'Payment successfully complete.');
        } else {
            return redirect()->route('user.buy.rent.details', $buyRent->id)->with('error', 'Payment not successfully complete.');
        }
    }
}
