<?php

namespace App\Http\Controllers\Deposit;

use App\Classes\GeniusMailer;
use App\Http\Controllers\Controller;
use App\Models\Currency;
use App\Models\Deposit;
use App\Models\Generalsetting;
use App\Models\PaymentGateway;
use App\Models\Transaction;
use Illuminate\Http\Request;

use Illuminate\Support\Str;

use Config;
use Illuminate\Support\Facades\Config as FacadesConfig;
use Illuminate\Support\Facades\Session;

class StripeController extends Controller
{
    public function __construct()
    {
        $data = PaymentGateway::whereKeyword('stripe')->first();
        $paydata = $data->convertAutoData();
        Config::set('services.stripe.key', $paydata['key']);
        Config::set('services.stripe.secret', $paydata['secret']);
    }

    public function store(Request $request)
    {

        $support = ['USD'];
        if (!in_array($request->currency_code, $support)) {
            return redirect()->back()->with('warning', 'Please Select USD Currency For Stripe.');
        }
        $gs = Generalsetting::findOrFail(1);

        try {

            $stripe_secret_key = Config::get('services.stripe.secret');
            \Stripe\Stripe::setApiKey($stripe_secret_key);
            $checkout_session = \Stripe\Checkout\Session::create([
                "mode" => "payment",
                "success_url" => route('deposit.stripe.notify') . '?session_id={CHECKOUT_SESSION_ID}',
                "cancel_url" => url()->previous(),
                "locale" => "auto",
                "line_items" => [
                    [
                        "quantity" => 1,
                        "price_data" => [
                            "currency" => $request->currency_code,
                            "unit_amount" => $request->amount * 100,
                            "product_data" => [
                                "name" => $gs->title . 'Deposit',
                            ]
                        ]
                    ],

                ]
            ]);

            Session::put('input_data', $request->all());
            return redirect($checkout_session->url);
        } catch (Exception $e) {
            
            return back()->with('warning', $e->getMessage());
        }

        return back()->with('warning', 'Please Enter Valid Credit Card Informations.');
    }


    public function notify(Request $request)
    {

        $requestData = (object) Session::get('input_data');
        $deposit = new Deposit();


        $item_amount = $request->amount;
        $stripe = new \Stripe\StripeClient(FacadesConfig::get('services.stripe.secret'));
        $response = $stripe->checkout->sessions->retrieve($request->session_id);


        if ($response->status == 'complete') {
            $currency = Currency::where('id', $requestData->currency_id)->first();
            $amountToAdd = $requestData->amount / $currency->value;
            $deposit['deposit_number'] = Str::random(12);
            $deposit['user_id'] = auth()->id();
            $deposit['currency_id'] = $requestData->currency_id;
            $deposit['amount'] = $amountToAdd;
            $deposit['method'] = $requestData->method;
            $deposit['txnid'] = $response->payment_intent;
            $deposit['status'] = "complete";
            $deposit->save();

            $gs =  Generalsetting::findOrFail(1);

            $user = auth()->user();
            $user->balance += $amountToAdd;
            $user->save();

            $trans = new Transaction();
            $trans->email = $user->email;
            $trans->amount = $amountToAdd;
            $trans->type = "Deposit";
            $trans->profit = "plus";
            $trans->txnid = $deposit->deposit_number;
            $trans->user_id = $user->id;
            $trans->save();


            if ($gs->is_smtp == 1) {
                $data = [
                    'to' => $user->email,
                    'type' => "Deposit",
                    'cname' => $user->name,
                    'oamount' => $item_amount,
                    'aname' => "",
                    'aemail' => "",
                    'wtitle' => "",
                ];

                $mailer = new GeniusMailer();
                $mailer->sendAutoMail($data);
            } else {
                $to = $user->email;
                $subject = " You have deposited successfully.";
                $msg = "Hello " . $user->name . "!\nYou have invested successfully.\nThank you.";
                $headers = "From: " . $gs->from_name . "<" . $gs->from_email . ">";
                mail($to, $subject, $msg, $headers);
            }

      
            return redirect()->route('user.deposit.create')->with('message', 'Deposit amount ' . $requestData->amount . ' ('.$currency->name.') successfully!');
        } else {
            return redirect()->route('user.deposit.create')->with('error', "Payment Failed!");
        }
    }
}
