<?php

namespace App\Http\Controllers\Frontend;

use App\Models\Blog;
use App\Models\Plan;
use App\Models\Room;
use App\Models\User;
use App\Models\Review;
use App\Models\Category;
use App\Models\Location;
use App\Models\Property;
use App\Models\Pagesetting;
use App\Models\SocialLinks;
use Illuminate\Support\Str;
use App\Models\SeenProperty;
use Illuminate\Http\Request;
use App\Models\PropertyReview;
use App\Http\Controllers\Controller;
use App\Services\PropertyService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Stevebauman\Location\Facades\Location as cLocation;


class CommercialController extends Controller
{

    public function __construct(private PropertyService $propertyService)
    {
    }

    public function index(Request $request, $location_name = null)
    {
        $data = [];
        if (!$location_name) {
            $city = config('app.search_default_city');
            return redirect()->route('buy.index.location', ['city' => Str::slug($city)]);
        }

        $currentLocation = Str::replace('-', ' ', $location_name);
        
        $data['testimonials'] = Review::orderBy('id', 'desc')->get();
        $data['plans'] = Plan::whereStatus(1)->orderBy('id', 'desc')->get();
        $data['categories'] = Category::whereStatus(1)->orderBy('id', 'desc')->get();

        $data['topCities'] = Location::where('status', 1)
            ->where('is_top_city', 1)
            ->orderBy('custom_order', 'asc')
            ->get();

        $data['otherCities'] = Location::where('status', 1)
            ->where('is_top_city', 0)
            ->orderBy('name', 'asc')
            ->get();

        $data['locations_for_section']  = Location::whereStatus(1)->orderBy('id', 'asc')->take(8)->get();
        $data['properties'] = Property::where('looking_for', '!=', 'for_pg')
            ->where('status', 1)
            ->where('is_invest', 0)
            ->orderBy('id', 'desc')
            ->where('type', 'commercial')
            ->whereNotIn('properties.category_id', [33, 32])
            ->limit(6)
            ->get();

        $data['featured_properties'] = Property::whereStatus(1)->whereIsInvest(0)->whereIsFeature(1)->orderBy('id', 'desc')->limit(8)->get();
        $data['blogs'] = Blog::orderBy('id', 'asc')->limit(6)->get();
        $data['ps'] = Pagesetting::first();
        $data['sociallinks'] = SocialLinks::orderBy('id', 'desc')->get();
        $data['home_modules'] = $data['ps']->home_module ? json_decode($data['ps']->home_module, true) : [];
        $data['currentLocation'] = $currentLocation;
        return view('frontend.commercial.index', $data);
    }
    public function buySearch(Request $request)
    {
        $keyword = $request->name;
        $location = $request->location_id;
        $category_id = $request->category_id;
        $sale_type = $request->sale_type ?? null;
        $construction_status = $request->construction_status;
        $minprice = $request->minPrice;
        $maxprice = $request->maxPrice;
        $minarea = $request->minArea;
        $maxarea = $request->maxArea;
        $user_type = $request->user_type ?: null;
        $ownership = $request->ownership ?: null;

        $bhkKeyword = null;
        $localityKeyword = null;
        $originalKeyword = $request->name;

        if ($keyword) {
            $keywords = [
                'one' => '1',
                'two' => '2',
                'three' => '3',
                'four' => '4',
                'five' => '5',
                'six' => '6',
            ];

            foreach ($keywords as $word => $digit) {
                $keyword = str_ireplace($word, $digit, $keyword);
            }

            $keyword = str_replace(',', '', $keyword);
            $normalizedKeyword = trim(strtoupper(preg_replace('/\s?(bhk|rk)\b/i', '-$1', $keyword)));

            if (stripos($keyword, ' in ') !== false) {
                [$bhkKeyword, $localityKeyword] = array_map('trim', explode(' in ', $keyword, 2));
                $bhkKeyword = preg_replace('/\s?(bhk|rk)\b/i', '-$1', $bhkKeyword);
            } else {
                if (stripos($keyword, 'bhk') !== false || stripos($keyword, 'rk') !== false) {
                    $bhkKeyword = $normalizedKeyword;
                } else {
                    $localityKeyword = $keyword;
                }
            }
        }

        $data['locations'] = Location::whereStatus(1)
            ->orderBy('custom_order')
            ->orderBy('name')
            ->get();

        $query = Property::with(['floorplans'])
            ->select('properties.*')
            ->where('properties.status', 1)
            ->where('properties.looking_for', 'for_sell')
            ->where('type', 'commercial')
            ->whereNotIn('properties.category_id', [32, 33]);

        // Location filter
        if ($location) {
            $query->join('locations', 'properties.location_id', '=', 'locations.id')
                ->where('locations.id', '=', $location);
        }

        // Locality keyword or general search
        if ($localityKeyword || $keyword) {
            $query->where(function ($q) use ($keyword, $localityKeyword, $originalKeyword) {
                $q->where('properties.name', 'LIKE', "%$keyword%")
                    ->orWhere('properties.locality', 'LIKE', "%$localityKeyword%")
                    ->orWhere('properties.sub_locality', 'LIKE', "%$keyword%")
                    ->orWhere('properties.building', 'LIKE', "%$keyword%")
                    ->orWhere('properties.furnish_type', 'LIKE', "%$keyword%");

                    // properties.category_id 
                    if (in_array(strtolower($originalKeyword), ['office', 'buy office'])) {
                        $q->orWhere('properties.category_id', '=', 38);
                    }
                    // properties.category_id 
                    else if (in_array(strtolower($originalKeyword), ['retail', 'buy retail'])) {
                        $q->orWhere('properties.category_id', '=', 39);
                    }
                    
                    // properties.retail_space_type
                    if (in_array(strtolower($originalKeyword), ['shop','shops','retail shop','retail shops','retail space','retail spaces','buy shop','buy shops','buy retail shop','buy retail shops','buy retail space','buy retail spaces'])) {
                        $q->orWhere('properties.retail_space_type', '=', "commercial-shops");
                    }
                    // properties.retail_space_type
                    else if (in_array(strtolower($originalKeyword), ['showroom', 'buy showroom'])) {
                        $q->orWhere('properties.retail_space_type', '=', "commercial-showrooms");
                    }
                    // properties.storage_space_type
                    else if (in_array(strtolower($originalKeyword), ['warehouse','buy warehouse'])) {
                        $q->orWhere('properties.storage_space_type', '=', "warehouse");
                    }
                    // properties.storage_space_type
                    else if (in_array(strtolower($originalKeyword), ['cold storage','buy cold storage'])) {
                        $q->orWhere('properties.storage_space_type', '=', "cold-storage");
                    }
                    // properties.hospitality_space_type 
                    else if (in_array(strtolower($originalKeyword), ['resorts','resort','hotel','hotels','buy resorts','buy resort','buy hotel','buy hotels'])) {
                        $q->orWhere('properties.hospitality_space_type', '=', "hotel");
                    }
                    // properties.hospitality_space_type 
                    else if (in_array(strtolower($originalKeyword), ['guest house', 'guest houses','banquet hall','buy guest house', 'buy guest houses','buy banquet hall'])) {
                        $q->orWhere('properties.hospitality_space_type', '=', "guest-house");
                    }
                    
            });
        }

        // Convert price filters to integers (remove commas)
        $minprice = $minprice ? (int)str_replace(',', '', $minprice) : null;
        $maxprice = $maxprice ? (int)str_replace(',', '', $maxprice) : null;
        
        // Treat 20cr (20,00,00,000) as no max price limit
        if ($maxprice === 200000000) {
            $maxprice = null;
        }
        
        if ($minprice !== null || $maxprice !== null) {
            $query->where(function ($q) use ($minprice, $maxprice) {
                if ($minprice !== null) {
                    $q->where('price', '>=', $minprice);
                }
                if ($maxprice !== null) {
                    $q->where('price', '<=', $maxprice);
                }
            });
        }
        
        // Convert area filters to integers (remove commas)
        $minarea = $minarea ? (int)str_replace(',', '', $minarea) : null;
        $maxarea = $maxarea ? (int)str_replace(',', '', $maxarea) : null;
        
        // Treat 5000 as no max area limit
        if ($maxarea === 5000) {
            $maxarea = null;
        }
        
        if ($minarea !== null || $maxarea !== null) {
            $query->where(function ($q) use ($minarea, $maxarea) {
                if ($minarea !== null) {
                    $q->where('carpet_area', '>=', $minarea);
                }
                if ($maxarea !== null) {
                    $q->where('carpet_area', '<=', $maxarea);
                }
            });
        }


        $userTypeFilter = $user_type;

        if ($userTypeFilter) {
            $query->join('users', 'users.id', '=', 'properties.user_id')
                ->where('users.user_type', $userTypeFilter);
        }
        // Category filter
        if ($category_id) {
            $query->where('category_id', $category_id);
        }

        // Sale type
        if ($sale_type) {
            $query->where('sale_type', $sale_type);
        }
        // Ownership
        if ($ownership) {
            $query->where('ownership', $ownership);
        }

        // Construction status / possesion status
        if ($construction_status) {
            $query->where('construction_status', $construction_status);
        }
        
        $topSlotProperties = $this->propertyService->getSponsoredPropertiesBySlot('commercial_buy', $location, 'Top', 2);
        $mediumSlotProperties = $this->propertyService->getSponsoredPropertiesBySlot('commercial_buy', $location, 'Medium', 2);

        $data['topSlotProperties'] = $topSlotProperties;
        $data['mediumSlotProperties'] = $mediumSlotProperties;

        $propertyIds = PropertyService::getSponsoredPropertyIds($topSlotProperties, $mediumSlotProperties);
        if(!empty($propertyIds)){
            $query->whereNotIn('properties.id',  $propertyIds);
        }

        $data['properties'] = $query->orderBy('id', 'desc')->paginate(30)->appends($request->query());

        $city = $location ? Location::find($location)?->name : null;
        $category = $category_id ? Category::find($category_id)?->title : null;

        return view('frontend.commercial.buy-form', $data)->with('searchData', [
            'keyword' => $keyword,
            'city' => $city,
            'category' => $category,
            'ownership' => $ownership,
            'minPrice' => $minprice,
            'maxPrice' => $maxprice,
            'minArea' => $minarea,
            'maxArea' => $maxarea,
            'saleType' => $sale_type,
            'userType' => $user_type,
            'constructionStatus' => $construction_status,
        ]);
    }
    public function leaseSearch(Request $request)
    {
        $keyword = $request->name;
        $location = $request->location_id;
        $category_id = $request->category_id;
        $construction_status = $request->construction_status;
        $minprice = $request->minPrice;
        $maxprice = $request->maxPrice;
        $minarea = $request->minArea;
        $maxarea = $request->maxArea;
        $user_type = $request->user_type ?: null;

        $originalKeyword = $request->name;

        $bhkKeyword = null;
        $localityKeyword = null;

        if ($keyword) {
            $keywords = [
                'one' => '1',
                'two' => '2',
                'three' => '3',
                'four' => '4',
                'five' => '5',
                'six' => '6',
            ];

            foreach ($keywords as $word => $digit) {
                $keyword = str_ireplace($word, $digit, $keyword);
            }

            $keyword = str_replace(',', '', $keyword);
            $normalizedKeyword = trim(strtoupper(preg_replace('/\s?(bhk|rk)\b/i', '-$1', $keyword)));

            if (stripos($keyword, ' in ') !== false) {
                [$bhkKeyword, $localityKeyword] = array_map('trim', explode(' in ', $keyword, 2));
                $bhkKeyword = preg_replace('/\s?(bhk|rk)\b/i', '-$1', $bhkKeyword);
            } else {
                if (stripos($keyword, 'bhk') !== false || stripos($keyword, 'rk') !== false) {
                    $bhkKeyword = $normalizedKeyword;
                } else {
                    $localityKeyword = $keyword;
                }
            }
        }

        $data['locations'] = Location::whereStatus(1)
            ->orderBy('custom_order')
            ->orderBy('name')
            ->get();

        $query = Property::with(['floorplans'])
            ->select('properties.*')
            ->where('properties.status', 1)
            ->where('properties.looking_for', 'for_rent')
            ->where('type', 'commercial')
            ->whereNotIn('properties.category_id', [32, 33]);

        // Location filter
        if ($location) {
            $query->join('locations', 'properties.location_id', '=', 'locations.id')
                ->where('locations.id', '=', $location);
        }

        // Locality keyword or general search
        if ($localityKeyword || $keyword || $originalKeyword) {
            $query->where(function ($q) use ($keyword, $localityKeyword, $originalKeyword) {
                $q->where('properties.name', 'LIKE', "%$keyword%")
                    ->orWhere('properties.locality', 'LIKE', "%$localityKeyword%")
                    ->orWhere('properties.sub_locality', 'LIKE', "%$keyword%")
                    ->orWhere('properties.building', 'LIKE', "%$keyword%")
                    ->orWhere('properties.furnish_type', 'LIKE', "%$keyword%")
                    ->orWhere('properties.name', 'LIKE', "%$originalKeyword%");

                    // properties.category_id 
                    if (in_array(strtolower($originalKeyword), ['office', 'buy office'])) {
                        $q->orWhere('properties.category_id', '=', 38);
                    }
                    // properties.category_id 
                    else if (in_array(strtolower($originalKeyword), ['retail', 'buy retail'])) {
                        $q->orWhere('properties.category_id', '=', 39);
                    }

                    // properties.retail_space_type
                    if (in_array(strtolower($originalKeyword), ['shop','shops','retail shop','retail shops','retail space','retail spaces','rent shop','rent shops','rent retail shop','rent retail shops','rent retail space','rent retail spaces'])) {
                        $q->orWhere('properties.retail_space_type', '=', "commercial-shops");
                    }
                    // properties.retail_space_type
                    else if (in_array(strtolower($originalKeyword), ['showroom', 'rent showroom'])) {
                        $q->orWhere('properties.retail_space_type', '=', "commercial-showrooms");
                    }
                    // properties.storage_space_type
                    else if (in_array(strtolower($originalKeyword), ['warehouse','rent warehouse'])) {
                        $q->orWhere('properties.storage_space_type', '=', "warehouse");
                    }
                    // properties.storage_space_type
                    else if (in_array(strtolower($originalKeyword), ['cold storage','rent cold storage'])) {
                        $q->orWhere('properties.storage_space_type', '=', "cold-storage");
                    }
                    // properties.hospitality_space_type 
                    else if (in_array(strtolower($originalKeyword), ['resorts','resort','hotel','hotels','rent resorts','rent resort','rent hotel','rent hotels'])) {
                        $q->orWhere('properties.hospitality_space_type', '=', "hotel");
                    }
                    // properties.hospitality_space_type 
                    else if (in_array(strtolower($originalKeyword), ['guest house', 'guest houses','banquet hall','rent guest house', 'rent guest houses','rent banquet hall'])) {
                        $q->orWhere('properties.hospitality_space_type', '=', "guest-house");
                    }
            });
        }

        // Convert price filters to integers (remove commas)
        $minprice = $minprice ? (int)str_replace(',', '', $minprice) : null;
        $maxprice = $maxprice ? (int)str_replace(',', '', $maxprice) : null;
        
        // Treat 20lac (20,00,000) as no max price limit
        if ($maxprice === 2000000) {
            $maxprice = null;
        }
        
        if ($minprice !== null || $maxprice !== null) {
            $query->where(function ($q) use ($minprice, $maxprice) {
                if ($minprice !== null) {
                    $q->where('price', '>=', $minprice);
                }
                if ($maxprice !== null) {
                    $q->where('price', '<=', $maxprice);
                }
            });
        }
        
        // Convert area filters to integers (remove commas)
        $minarea = $minarea ? (int)str_replace(',', '', $minarea) : null;
        $maxarea = $maxarea ? (int)str_replace(',', '', $maxarea) : null;
        
        // Treat 20000 as no max area limit
        if ($maxarea === 20000) {
            $maxarea = null;
        }
        
        if ($minarea !== null || $maxarea !== null) {
            $query->where(function ($q) use ($minarea, $maxarea) {
                if ($minarea !== null) {
                    $q->where('carpet_area', '>=', $minarea);
                }
                if ($maxarea !== null) {
                    $q->where('carpet_area', '<=', $maxarea);
                }
            });
        }

        $userTypeFilter = $user_type;

        if ($userTypeFilter) {
            $query->join('users', 'users.id', '=', 'properties.user_id')
                ->where('users.user_type', $userTypeFilter);
        }
        // Category filter
        if ($category_id) {
            $query->where('category_id', $category_id);
        }

        // Construction status / possesion status
        if ($construction_status) {
            $query->where('construction_status', $construction_status);
        }
        
        
        $topSlotProperties = $this->propertyService->getSponsoredPropertiesBySlot('commercial_rent', $location, 'Top', 2);
        $mediumSlotProperties = $this->propertyService->getSponsoredPropertiesBySlot('commercial_rent', $location, 'Medium', 2);

        $data['topSlotProperties'] = $topSlotProperties;
        $data['mediumSlotProperties'] = $mediumSlotProperties;

        $propertyIds = PropertyService::getSponsoredPropertyIds($topSlotProperties, $mediumSlotProperties);
        if(!empty($propertyIds)){
            $query->whereNotIn('properties.id',  $propertyIds);
        }

        $data['properties'] = $query->orderBy('id', 'desc')->paginate(30)->appends($request->query());

        $city = $location ? Location::find($location)?->name : null;
        $category = $category_id ? Category::find($category_id)?->title : null;

        return view('frontend.commercial.lease-form', $data)->with('searchData', [
            'keyword' => $keyword,
            'city' => $city,
            'category' => $category,
            'minPrice' => $minprice,
            'maxPrice' => $maxprice,
            'minArea' => $minarea,
            'maxArea' => $maxarea,
            'userType' => $user_type,
            'constructionStatus' => $construction_status,
        ]);
    }
    public function details($slug)
    {
        $data = Property::whereSlug($slug)
            ->with(['facilities', 'facilityDistances.facility', 'enquiries'])
            ->whereStatus(1)
            ->first();
        $isContacted = false;

        if ($data) {
            $isContacted = optional($data->enquiries)
                ->where('user_id', auth()->id())
                ->where('property_id', $data->id)
                ->isNotEmpty();

            $data->isContacted = $isContacted;
        } else {
            $data = (object) ['isContacted' => false];
        }

        $userId = Auth::id();
        if ($userId) {
            SeenProperty::firstOrCreate([
                'user_id' => $userId,
                'property_id' => $data->id
            ]);
        }
        if (PropertyReview::wherePropertyId($data->id)->get()) {
            $data['reviews'] = PropertyReview::wherePropertyId($data->id)->whereStatus(1)->get();
        }
        $data['featured_properties'] = Property::whereStatus(1)
            ->whereIsInvest(0)
            ->whereIsFeature(1)
            ->orderBy('id', 'desc')
            ->limit(8)
            ->get();
        $data['data'] = $data;

        if ($data) {
            return view('frontend.commercial.property_details', $data);
        } else {
            return view('errors.404');
        }
    }
}
