<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Location;
use App\Models\Property;
use Illuminate\Http\Request;

class InvestController extends Controller
{
    public function invests(Request $request){
        $keyword = $request->name ? $request->name : null;
        $location = $request->location_id ? $request->location_id : null;
        $minprice = $request->min ? $request->min : null;
        $maxprice = $request->max ? $request->max : null;

        $data['locations']  = Location::whereStatus(1)->orderBy('id','desc')->get();

        $data['properties'] = Property::with('facilityDistances.facility','floorplans')
                                        ->when($keyword, function ($q) use ($keyword) {
                                            $q->where('name', 'LIKE', "%$keyword%")
                                            ->orWhereHas('floorplans', function ($query) use ($keyword) {
                                                $query->where('size', 'LIKE', "%$keyword%")
                                                        ->orWhere('name', 'LIKE', "%$keyword%");
                                            })
                                            ->orWhereHas('facilityDistances.facility', function ($query) use ($keyword) {
                                                $query->where('name', 'LIKE', "%$keyword%");
                                            });
                                        })
                                        ->when($location, function ($q) use ($location) {
                                            return $q->whereLocationId($location);
                                        })
                                        ->when($minprice, function($query, $minprice) {
                                            return $query->where('price', '>=', $minprice);
                                        })
                                        ->when($maxprice, function($query, $maxprice) {
                                            return $query->where('price', '<=', $maxprice);
                                        })
                                        ->whereIsInvest(1)
                                        ->whereStatus(1)
                                        ->orderBy('id', 'desc')
                                        ->paginate(15);

        return view('frontend.invest_properties',$data);
    }
}
