<?php

namespace App\Http\Controllers\Subscription;

use App\Repositories\SubscriptionRepository;

use Illuminate\Support\Facades\Config;
use App\Http\Controllers\Controller;
use App\Models\Generalsetting;
use App\Models\PaymentGateway;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class StripeController extends Controller
{
    public $subscriptionRepositorty;

    public function __construct(SubscriptionRepository $subscriptionRepositorty)
    {
        $data = PaymentGateway::whereKeyword('Stripe')->first();
        $paydata = $data->convertAutoData();

        Config::set('services.stripe.key', $paydata['key']);
        Config::set('services.stripe.secret', $paydata['secret']);

        $this->subscriptionRepositorty = $subscriptionRepositorty;
    }

    public function store(Request $request)
    {
        $settings = Generalsetting::findOrFail(1);
        $item_name = $settings->title . " Subscription";

        $item_amount = $request->price;


        $support = ['USD'];
        if (!in_array($request->currency_code, $support)) {
            return back()->with('warning', '');
        }


        try {

            $stripe_secret_key = Config::get('services.stripe.secret');
            \Stripe\Stripe::setApiKey($stripe_secret_key);
            $checkout_session = \Stripe\Checkout\Session::create([
                "mode" => "payment",
                "success_url" => route('subscription.stripe.notify') . '?session_id={CHECKOUT_SESSION_ID}',
                "cancel_url" => url()->previous(),
                "locale" => "auto",
                "line_items" => [
                    [
                        "quantity" => 1,
                        "price_data" => [
                            "currency" => $request->currency_code,
                            "unit_amount" => $item_amount * 100,
                            "product_data" => [
                                "name" => $item_name
                            ]
                        ]
                    ],

                ]
            ]);

            Session::put('input_data', $request->all());
            return redirect($checkout_session->url);
        } catch (Exception $e) {
            return back()->with('warning', $e->getMessage());
        }
    }


    public function notify(Request $request)
    {
        $inputData = (object) Session::get('input_data');

        $stripe = new \Stripe\StripeClient(Config::get('services.stripe.secret'));
        $response = $stripe->checkout->sessions->retrieve($request->session_id);

        if ($response->status == 'complete') {
            try {
                $addionalData = ['subscription_number' => Str::random(12), 'txnid' => $response->payment_intent];
                $this->subscriptionRepositorty->order($inputData, 'complete', $addionalData);
                return redirect()->route('user.dashboard')->with('message', 'Plan Updated Successfully');
            } catch (Exception $e) {
                return back()->with('error', $e->getMessage());
            }
        } else {
            return back()->with('error', __('Something is wrong.'));
        }
    }
}
