<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class EmailVerificationNotificationController extends Controller
{
    /**
     * Send a new email verification notification.
     */

    public function store(Request $request)
    {
        if ($request->user()->hasVerifiedEmail()) {
            return response()->json([
                'status' => 'already_verified',
                'message' => 'Email is already verified.'
            ], 200);
        }

        try {
            $request->user()->sendEmailVerificationNotification();

            return response()->json([
                'status' => 'success',
                'message' => 'Verification link sent successfully.'
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to send verification link.',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    // public function store(Request $request): RedirectResponse
    // {
    //     if ($request->user()->hasVerifiedEmail()) {
    //         return redirect()->intended(route('dashboard', absolute: false));
    //     }

    //     $request->user()->sendEmailVerificationNotification();

    //     return back()->with('status', 'verification-link-sent');
    // }
}
