<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Auth\Events\Verified;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;
use App\Models\User;

class VerifyEmailController extends Controller
{
    
public function verify(Request $request)
{
    // Require user to be logged in
    if (!Auth::check()) {
        // Save the intended URL so user returns after login
        session(['url.intended' => URL::full()]);
        return redirect()->route('user.otp')->with('message', 'Please log in to verify your email.');
    }

    $user = User::findOrFail($request->route('id'));

    //Check if the logged-in user is the same as the user being verified
    if ($request->user()->id !== $user->id) {
        abort(403, 'This verification link does not belong to the current user.');
    }

    //  Check hash
    if (!hash_equals((string) $request->route('hash'), sha1($user->getEmailForVerification()))) {
        abort(403, 'Invalid verification link.');
    }

    //  Already verified
    if ($user->hasVerifiedEmail()) {
        return $this->redirectAfterVerification($user);
    }

    //  Mark as verified
    $user->markEmailAsVerified();
    event(new Verified($user));

    return $this->redirectAfterVerification($user);
}

private function redirectAfterVerification($user)
{
    if (in_array($user->user_type, ['agent', 'owner'])) {
        return redirect()->route('agent.dashboard')
            ->with('verified', true)
            ->with('message', 'Your email has been successfully verified.');
    } else {
        return redirect()->route('user.dashboard')
            ->with('verified', true)
            ->with('message', 'Your email has been successfully verified.');
    }
}

}
