<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExpiredUserPackage extends Model
{
    use HasFactory;
    protected $table = 'expired_user_packages';
    protected $fillable = [
        'user_id',
        'plan_id',
        'activated_at',
        'expired_at',
        'status',
    ];

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
