<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Facility_Distance extends Model
{
    use HasFactory;
    protected $table = 'facilities_distances';
    protected $fillable = [
        'property_id',
        'facility_id',
        'distance',
        'distance_unit'
    ];
    public function property()
    {
        return $this->belongsTo(Property::class);
    }

    public function facility()
    {
        return $this->belongsTo(Facility::class);
    }

}
