<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FloorPlan extends Model
{
    use HasFactory;
    protected $fillable = [
        'property_id',
        'name',
        'floor_name',
        
        'size',
        'photo',
        'no_of_bathroom',
        'no_of_balcony',
        'furnish_type',
        'built_up_area',
        'carpet_area',
        'area_unit',
        'total_floors',
        'property_on_floor',
        'expected_price',
        'open_parking',
        'covered_parking',
        'price_per_sqft',
    ];

    public function property()
    {
        return $this->belongsTo(Property::class);
    }
    public function images()
    {
        return $this->hasMany(FloorPlanImage::class);
    }
}
