<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FloorPlanImage extends Model
{
    use HasFactory;
    protected $fillable = [
        'floor_plan_id',
        'image_path',
    ];
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    public function floorPlan()
    {
        return $this->belongsTo(FloorPlan::class, 'floor_plan_id');
    }
    // public function getImageUrlAttribute()
    // {
    //     return asset('storage/' . $this->image_path);
    // }
}
