<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlanHisory extends Model
{
    use HasFactory;
    protected $table = 'plan_hisories';
    protected $fillable = [
        'user_id',
        'plan_id',
        'status',
        'activated_at',
        'expired_at',
    ];

    /**
     * Get the user that owns the plan history.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    /**
     * Get the plan associated with the plan history.
     */
    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }
}
