<?php

namespace App\Models;

// use Laravel\Scout\Searchable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Property extends Model
{
    use HasFactory, SoftDeletes;
    protected $dates = ['deleted_at'];

    protected $fillable = [
        'user_id',
        'admin_id',
        'name',
        'slug',
        'description',
        'price',
        'bed',
        'bathroom',
        'square',
        'garage',
        'year_built',
        'area',
        'location_id',
        'real_address',
        'latitude',
        'longitude',
        'remodel_year',
        'pool_size',
        'additional_room',
        'amenities',
        'equipment',
        'category_id',
        'photo',
        'embed_video',
        'attributes',
        'type',
        'funding_amount',
        'invest_amount',
        'is_invest',
        'is_primium',
        'active_date',
        'expire_date',
        'min_invest',
        'max_invest',
        'income_distribution',
        'gross_yeild',
        'payment_duration',
        'status',
        'looking_for',
        'sale_type',
        'construction_status',
        'property_age',
        'possession_date',
        'no_of_bhk',
        'no_of_bathroom',
        'no_of_balcony',
        'covered_parking',
        'open_parking',
        'furnish_type',
        'built_up_area',
        'carpet_area',
        'property_on_floor',
        'total_floors',
        'price_per_sqft',
        'city',
        'building',
        'locality',
        'sub_locality',
        'plot_area',
        'area_unit',
        'plot_length',
        'plot_width',
        'floors_allowed',
        'boundary_wall',
        'open_sides',
        'construction_done',
        'construction_type',
        'possession_status',
        'plot_possession_date',
        'ownership',
        'expacted_price',
        'located_inside',
        'other_located_inside',
        'zone_type',
        'retail_space_type',
        'storage_space_type',
        'hospitality_space_type',
        'industrial_apace_type',
        'plot_space_type',
        'pg_for',
        'suited_for',
        'meals_available',
        'meal_offerings',
        'notice_period',
        'lock_in_period',
        'common_areas',
        'total_beds',
        'caretaker',
        'is_manager_stays',
        'veg_allowed',
        'opposit_sex_allowed',
        'any_time_allowed',
        'last_entry_time',
        'visitors_allowed',
        'guardians_allowed',
        'drinking_allowed',
        'smoking_allowed',
        'meal_speciality',
        'electricity_charges',
        'meal_charges',
        'move_charges',
        'additional_info',
    ];

    public function toSearchableArray()
    {
        $this->loadMissing(['user', 'category', 'location', 'facilities']);

        // Start with all fillable fields
        $array = $this->only($this->fillable);

        // Add related models / extra info
        $array['user_name'] = optional($this->user)->name;
        $array['category'] = optional($this->category)->name;
        $array['location_name'] = optional($this->location)->name;
        $array['facilities'] = $this->facilities->pluck('name')->implode(' ');

        return $array;
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function location()
    {
        return $this->belongsTo(Location::class);
    }

    public function galleries()
    {
        return $this->hasMany(Gallery::class);
    }

    public function floorplans()
    {
        return $this->hasMany(FloorPlan::class);
    }

    public function rooms()
    {
        return $this->hasMany(Room::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function admin()
    {
        return $this->belongsTo(Admin::class, 'admin_id');
    }

    public function wishlists()
    {
        return $this->hasMany(Wishlists::class);
    }

    public function buyrents()
    {
        return $this->hasMany(BuyRent::class);
    }

    public function reviews()
    {
        return $this->hasMany(PropertyReview::class);
    }

    public function enquiries()
    {
        return $this->hasMany(PropertyEnquiry::class);
    }

    public function invests()
    {
        return $this->hasMany(Invest::class);
    }

    public function checkFavourite($userId, $propertyId)
    {
        if (Wishlists::whereUserId($userId)->wherePropertyId($propertyId)->exists()) {
            return true;
        }
        return false;
    }

    public function checkSaveProperty($userId, $propertyId)
    {
        if (SavedProperty::whereUserId($userId)->wherePropertyId($propertyId)->exists()) {
            return true;
        }
        return false;
    }

    public function facilityDistances()
    {
        return $this->hasMany(Facility_Distance::class);
    }

    public function facilities()
    {
        return $this->hasManyThrough(Facility::class, Facility_Distance::class, 'property_id', 'id', 'id', 'facility_id');
    }

    public function seenByUsers()
    {
        return $this->belongsToMany(User::class, 'seen_properties');
    }

    public function savedByUsers()
    {
        return $this->belongsToMany(User::class, 'saved_properties');
    }
    public function recentSearchesByUsers()
    {
        return $this->belongsToMany(User::class, 'recent_search_properties');
    }
}
