<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Room extends Model
{
    use HasFactory;
    protected $fillable = [
        'property_id',
        'rent',
        'deposit',
        'photo',
        'type',
        'total_beds',
        'facilities',
    ];
    public function property()
    {
        return $this->belongsTo(Property::class);
    }
    public function getRentAttribute($value)
    {
        return (int) $value;
    }

    // Accessor for deposit
    public function getDepositAttribute($value)
    {
        return (int) $value;
    }
}
