<?php

namespace App\Services;

use App\Models\Property;

class PropertyService
{

    public function __construct()
    {
        // Initialization code if needed
    }

    /*
        propertyType: buy, rent, commercial, pg, plot.

    */
    public function getSponsoredPropertiesBySlot($propertyType, $locationId, $slot = 'Top', $limit = 2)
    {

        $lookingFor = match ($propertyType) {
            'buy' => 'for_sell',
            'rent' => 'for_rent',
            'commercial_buy' => 'for_sell',
            'commercial_rent' => 'for_rent',
            'pg' => 'for_pg',
            'plot' => 'for_sell',
            default => 'for_sell',
        };
        $propertyTypeString = match ($propertyType) {
            'buy' => 'residential',
            'rent' => 'residential',
            'commercial_buy' => 'commercial',
            'commercial_rent' => 'commercial',
            'pg' => 'residential',
            // 'plot' => 'residential',
            default => 'residential',
        };

        $query = Property::query()
            ->with(['floorplans'])
            ->select('properties.*')
            ->join('locations', 'properties.location_id', '=', 'locations.id')
            ->where('properties.status', 1)
            ->where('properties.looking_for', $lookingFor)
            ->where('locations.id', $locationId)
            ->whereNull('properties.deleted_at');


        if ($propertyType == 'plot') {
            $query->whereIn('properties.category_id', [33, 32]);
            // $query->where('properties.type', $propertyTypeString);
        } else {
            $query->whereNotIn('properties.category_id', [32, 33]);
            $query->where('properties.type', $propertyTypeString);
        }

        if ($lookingFor == 'for_rent') {
            $query->whereHas('user', function ($query) {
                $query->where('user_type', '!=', 'builder/developer');
            });
        }

        // get premuium plan users properties by slot and boost only
        $query->join('users', 'users.id', '=', 'properties.user_id')
            ->join('plans', 'plans.id', '=', 'users.plan_id')
            ->where('users.plan_id', '!=', null)
            ->where('plans.slot', $slot)
            ->orderByRaw('RAND() * plans.boost DESC');


        $properties = $query->limit($limit)->get();

        return $properties;
    }

    public static function getSponsoredPropertyIds($topSlotProperties, $mediumSlotProperties)
    {
        // $properties is a collection of Property models
        $topPropertiesIds = $topSlotProperties->pluck('id')->toArray();
        $mediumPropertiesIds = $mediumSlotProperties->pluck('id')->toArray();
        return (array) array_merge($topPropertiesIds, $mediumPropertiesIds);
    }
}
