<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use App\Models\Settings;
use Exception;

class SendSmsService
{
    public static function sendOTPSMS($mobile, $otp, $serviceName)
    {
        $message = "$otp is your OTP for service - $serviceName. Never share OTP. Visit at veloxinfra.com WTMIT";
        info($message);
        $templateId = "1607100000000337045";
        return self::sendSMS($mobile, $message, $templateId);
    }

    public static function sendSignupSMS($mobile, $name, $username, $password)
    {
        $message = "Dear " . substr($name, 0, 30) . ", Welcome to veloxinfra.com. Your username is " . substr($username, 0, 30) . " and password is " . substr($password, 0, 30) . ". Visit us on veloxinfra.com WTMITC";
        // $message = "Welcome " . substr($name, 0, 30) . ", to Veloxinfra property company. Your Login ID is " . substr($username, 0, 30) . " and Your password is " . substr($password, 0, 30) . ". For Login visit www.veloxinfra.com WTMITC";
        $templateId = "1607100000000284053";
        return self::sendSMS($mobile, $message, $templateId);
    }

    public static function sendSMS($mobile, $message, $templateId)
    {
        if (!empty($mobile) && !empty($message) && !empty($templateId)) {
            // $username = 'Wtmitltd'; // old username and apiKey
            // $apiKey = '9B566-0635E';
            $username = 'veloxinfra';
            $senderId = 'WTMITC';
            $apiKey = '36096-FABCA';
            $url = "https://sms.infrainfotech.com/sms-panel/api/http/index.php";

            $params = [
                'username' => $username,
                'apikey' => $apiKey,
                'apirequest' => 'Text',
                'sender' => $senderId,
                'mobile' => $mobile,
                'message' => $message,
                'route' => 'OTP',
                'TemplateID' => $templateId,
                'format' => 'JSON',
            ];

            $fullUrl = $url . '?' . http_build_query($params);
            info("SMS API Request URL: $fullUrl");

            try {
                $response = Http::asForm()->post($url, $params);
                info("SMS API Response", ['response' => $response->body()]);

                if ($response->successful()) {
                    return ['status' => 'SUCCESS', 'response' => $response->json()];
                } else {
                    return ['status' => 'ERROR', 'error' => $response->body()];
                }
            } catch (\Exception $e) {

                info("SMS API Exception", ['error' => $e->getMessage()]);
                return ['status' => 'ERROR', 'error' => $e->getMessage()];
            }
        }

        return ['status' => 'ERROR', 'error' => 'Invalid mobile number or message'];
    }
}

