<?php

namespace App\Services;

use Exception;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use App\Models\Generalsetting;

class WhatsAppService
{
    protected $apiUrl;
    protected $accessToken;
    protected $channelId;
    protected $whatsappApiStatus;

    public function __construct()
    {
        $settings = Generalsetting::first();

        $this->whatsappApiStatus = $settings?->whatsapp_status == 1;
        $this->channelId = $settings?->whatsapp_channelId ?? '';
        $this->accessToken = $settings?->whatsapp_accessToken ?? '';
        $this->apiUrl = $settings?->whatsapp_api_url . '/' . $this->channelId;
    }

    public function sendMessageWithTemplate(string $mobileNumber, string $templateName, ?string $headerImageUrl = null)
    {
         return ['status' => false, 'message' => 'Failed to send message', 'error' => 'temprorarily disabled'];
        // dd($mobileNumber . ' ' . $templateName . ' ' . $this->accessToken . ' ' . $this->channelId . ' ' . $this->whatsappApiStatus . ' ' . $this->apiUrl);

        if (!$this->whatsappApiStatus) {
            return [
                'status' => false,
                'message' => 'WhatsApp messaging is currently disabled. Please contact support or try again later.'
            ];
        }
        try {
            $components = [];

            $templatePayload = [
                "name" => $templateName,
                "language" => [
                    "code" => 'en'
                ]
            ];

            if (!empty($headerImageUrl)) {
                $components[] = [
                    "type" => "header",
                    "parameters" => [
                        [
                            "type" => "image",
                            "image" => [
                                "link" => $headerImageUrl
                            ]
                        ]
                    ]
                ];
            }

            if (!empty($components)) {
                $templatePayload["components"] = $components;
            }

            $data = [
                "messaging_product" => "whatsapp",
                "recipient_type" => "individual",
                "to" => $mobileNumber,
                "type" => "template",
                "template" => $templatePayload
            ];

            $response = Http::withToken($this->accessToken)->post($this->apiUrl, $data);

            if ($response->successful()) {
                return ['status' => true, 'message' => 'Message sent successfully', 'response' => $response->json()];
            } else {
                Log::error('WhatsApp API Error', ['response' => $response->body()]);
                return ['status' => false, 'message' => 'Failed to send message', 'error' => $response->body()];
            }
        } catch (Exception $e) {
            Log::error('WhatsApp Exception', ['error' => $e->getMessage()]);
            return ['status' => false, 'message' => 'Exception occurred', 'error' => $e->getMessage()];
        }
    }
}
