<?php

namespace App\View\Components;

use Illuminate\View\Component;

class SelectUnit extends Component
{
    public $name;
    public $label;
    public $selected;
    public $units;

    public function __construct($name = 'area_unit', $label = 'Select Unit', $selected = null)
    {
        $this->name = $name;
        $this->label = $label;
        $this->selected = old($name, $selected);
        $this->units = [
            'sqft' => 'Sq Ft',
            'sqm' => 'Sq Meter',
            'acres' => 'Acres',
        ];
    }

    public function render()
    {
        return view('components.select-unit');
    }
}
