@extends('layouts.admin')
@section('content')
<div class="card">
    <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Property') }}</h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="javascript:;">{{ __('Property') }}</a></li>
        </ol>
    </div>
<div class="row mt-3">
    <div class="col-lg-12">
        @include('includes.admin.form-success')
        <div class="card mb-4">
            <div class="table-responsive p-3">
                <table id="properties-table" class="table table-hover table-smaller" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>{{ __('Image') }}</th>
                            <th>{{ __('Title') }}</th>
                            <th>{{ __('Category') }}</th>
                            <th width="100">{{ __('Created') }}</th>
                            <th width="100">{{ __('Updated') }}</th>
                            <th>{{ __('Info') }}</th>
                            <th>{{ __('Price') }}</th>
                            <th>{{ __('Type') }}</th>
                            <th>{{ __('Status') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
$(document).ready(function() {
    const table = $('#properties-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('admin.agents.properties.datatables', $id) }}",
        columns: [
            { data: 'photo', searchable: false, orderable: false },
            { data: 'name' },
            { data: 'category_id' },
            { data: 'created_at', width: '100px' },
            { data: 'updated_at', width: '100px' },
            { data: 'extra_info', searchable: false, orderable: false },
            { data: 'price' },
            { data: 'type' },
            { data: 'status' }
        ],
        language: {
            processing: "<img src='{{ asset('assets/images/'.$gs->admin_loader) }}'>"
        }
    });
});
</script>
@endsection