@extends('layouts.admin')
@section('content')
    <div class="content-area">
        <div class="card">
            <div class="d-sm-flex align-items-center justify-content-between">
                <h5 class=" mb-0 text-gray-800 pl-3">{{ __('All Settings') }}</h5>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('admin.gs.default') }}">{{ __('All Settings') }}</a></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            <div class="card p-4 py-5">
                <h4 class="mb-3"><i class="fas fa-cogs text-primary"></i> Settings Overview</h4>
                <p>This section allows the administrator to manage and configure various system settings, including
                    website appearance, SEO, user permissions, integrations, and more.</p>

                <ul class="list-group mt-3">
                    <li class="list-group-item">
                        <i class="fas fa-sliders-h text-secondary mr-2"></i> General Settings
                    </li>
                    <li class="list-group-item">
                        <i class="fas fa-envelope text-secondary mr-2"></i> Email Configuration
                    </li>
                    <li class="list-group-item">
                        <i class="fab fa-whatsapp text-secondary mr-2"></i> WhatsApp Integration
                    </li>
                    <li class="list-group-item">
                        <i class="fas fa-palette text-secondary mr-2"></i> Design Customization
                    </li>
                    <li class="list-group-item">
                        <i class="fas fa-shield-alt text-secondary mr-2"></i> Security & Permissions
                    </li>
                </ul>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
@endsection
