@extends('layouts.admin')

@section('content')
<div class="card">
    <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class="mb-0 text-gray-800 pl-3">{{ __('Add New Location') }}
            <a class="btn btn-primary btn-rounded btn-sm" href="{{ route('admin.locations.index') }}">
                <i class="fas fa-arrow-left"></i> {{ __('Back') }}
            </a>
        </h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="javascript:;">{{ __('Location') }}</a></li>
        </ol>
    </div>
</div>

    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            
        <div class="card mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">{{ __('Add new location form') }}</h6>
            </div>

            <div class="card-body">
                <form class="" action="{{ route('admin.add-state') }}" method="POST" enctype="multipart/form-data">
                    @include('includes.admin.form-both')
                    {{ csrf_field() }}

                    <!-- Country -->
                    <div class="form-group">
                        <label for="inp-country">{{ __('Country') }}</label>
                        <select class="form-control" name="country_id" id="countrySelect">
                            <option value="" selected>{{ __('Select Country') }}</option>
                            @foreach ($countries as $key => $country)
                                <option value="{{ $country->id }}" {{ old('country_id') == $country->id ? 'selected' : '' }}>
                                    {{ $country->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('country_id')
                        <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                    <!-- States -->
                    <label for="state">{{ __('State') }}</label>
                    <div id="dynamicFormContainer">
                        @if (old('states'))
                            @foreach (old('states') as $state)
                                <div class="row dynamic-form">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <input type="text" class="form-control" name="states[]" placeholder="{{ __('Enter State Name') }}" value="{{ $state }}" >
                                        </div>
                                        @error('states.*')
                                        <small class="text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="row dynamic-form">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="states[]" placeholder="{{ __('Enter State Name') }}" >
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>

                    <button type="button" id="addNewForm" class="btn btn-primary my-3">{{ __('Add Another State') }}</button>
                    <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.getElementById('addNewForm').addEventListener('click', function() {
        const formContainer = document.getElementById('dynamicFormContainer');
        const newForm = formContainer.querySelector('.dynamic-form').cloneNode(true);
        newForm.querySelector('input[name="states[]"]').value = '';
        formContainer.appendChild(newForm);
    });
</script>
@endsection
