@extends('layouts.admin')

@section('content')

    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">City List</h5>
                <form id="filter-form" class="form-inline">
                    <label class="mr-2 font-weight-bold" for="state_filter">Filter by State:</label>
                    <select id="state_filter" name="state_id" class="form-control">
                        <option value="">All States</option>
                        @foreach(\App\Models\State::whereHas('country', fn($q) => $q->where('name', 'India'))->get() as $state)
                            <option value="{{ $state->id }}">{{ $state->name }}</option>
                        @endforeach
                    </select>
                </form>
            </div>

            <div class="table-responsive p-3">
                <table id="geniustable" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S.No.</th>
                            <th>City Name</th>
                            <th>State</th>
                            <th>Country</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(function () {
    let table = $('#geniustable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('admin.city.list') }}",
            data: function (d) {
                d.state_id = $('#state_filter').val();
            }
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'name', name: 'name' },
            { data: 'state_name', name: 'state.name' },
            { data: 'country_name', name: 'state.country.name' },
        ]
    });

    $('#state_filter').change(function () {
        table.ajax.reload();
    });
});
</script>
@endsection
