@extends('layouts.admin')

@section('content')
<div class="card">
  <div class="d-sm-flex align-items-center justify-content-between">
  <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Add New Location') }} <a class="btn btn-primary btn-rounded btn-sm" href="{{route('admin.locations.index')}}"><i class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
  <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
      <li class="breadcrumb-item"><a href="javascript:;">{{ __('Location') }}</a></li>
  </ol>
  </div>
</div>

    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
    <div class="card mb-4">
      <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">{{ __('Add new location form') }}</h6>
      </div>

      <div class="card-body">
        <form class="geniusform" action="{{route('admin.locations.store')}}" method="POST" enctype="multipart/form-data">

            {{ csrf_field() }}

            <div class="form-group">
                <label for="country">{{ __('Country') }}</label>
                <input type="text" class="form-control" id="country" name="country" placeholder="{{ __('Enter Country') }}" required>
            </div>

            <div class="form-group">
                <label for="state">{{ __('State') }}</label>
                <input type="text" class="form-control" id="state" name="state" placeholder="{{ __('Enter state') }}" required>
            </div>

            <div class="form-group">
                <label for="city">{{ __('City') }}</label>
                <input type="text" class="form-control" id="city" name="city" placeholder="{{ __('Enter city') }}" required>
            </div>


            <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>
          </form>

      </div>
    </div>
  </div>
</div>

@endsection

@section('scripts')
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBIwLEvoQ-NU-tjwEtnr2_SL4nXEvJKjeM&libraries=places"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        // Initialize autocomplete fields
        const countryAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById('country'),
            { types: ['(regions)'] }
        );

        const stateAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById('state'),
            { types: ['(regions)'] }
        );

        const cityAutocomplete = new google.maps.places.Autocomplete(
            document.getElementById('city'),
            { types: ['(cities)'] }
        );

        // Restrict states based on the selected country
        $('#country').blur(function () {
            const country = $('#country').val();
            if (country) {
                stateAutocomplete.setOptions({
                    componentRestrictions: { country: getCountryCode(country) }, // Convert country name to country code
                });

                $('#state').val('');
                $('#city').val('');
            }
        });

        // Restrict cities based on the selected state
        $('#state').blur(function () {
            const state = $('#state').val();
            if (state) {
                cityAutocomplete.setOptions({
                    types: ['(cities)'],
                });

                $('#city').val('');
            }
        });

        // Function to convert country name to ISO Alpha-2 country code
        function getCountryCode(countryName) {
            const countryList = {
                "United States": "US",
                "India": "IN",
                "Canada": "CA",
                "Australia": "AU",
                "United Kingdom": "GB",
                // Add more countries as needed
            };
            return countryList[countryName] || null;
        }
    });
</script>

@endsection
