@extends('layouts.admin')
<style>
    input[type="radio"] {
        display: none;
    }

    input[type="radio"]:checked+label {
        background-color: #007bff;
        color: #fff;
        border-color: #007bff;
    }

    input[type="radio"]:hidden+.parking-label {
        background-color: #e9ecef;
        color: #000;
    }

    input[type="radio"]:checked+.parking-label {
        background-color: #007bff;
        color: #fff;
        border-color: #0056b3;
    }

    .custom-control-input {
        display: none;
    }
</style>
@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class="mb-0 text-gray-800 pl-3">{{ __('Edit Location') }}
                <a class="btn btn-primary btn-rounded btn-sm" href="{{ route('admin.locations.index') }}">
                    <i class="fas fa-arrow-left"></i> {{ __('Back') }}
                </a>
            </h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Location') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Edit Location Form') }}</h6>
                </div>

                <div class="card-body">
                    <form class="" action="{{ route('admin.locations.update', $data->id) }}" method="POST">
                        @csrf
                        {{-- @method('PUT') --}}

                        @include('includes.admin.form-both')

                        <div id="dynamicFormContainer">
                            <div class="card dynamic-form">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="inp-name">{{ __('Country') }}</label>
                                                <select class="form-control mb-3" name="country_id">
                                                    <option value="" disabled {{ !$data->country_id ? 'selected' : '' }}>
                                                        {{ __('Select Country') }}
                                                    </option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            {{ $data->country_id == $country->id ? 'selected' : '' }}>
                                                            {{ $country->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="state">{{ __('State') }}</label>
                                                <select class="form-control" id="state" name="state_id">
                                                    <option value="" disabled>{{ __('Select State') }}</option>
                                                    @foreach ($states as $state)
                                                        <option value="{{ $state->id }}" {{ $data->state_id == $state->id ? 'selected' : '' }}>
                                                            {{ $state->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>{{ __('City Type') }}</label><br>
                                                <select class="form-control ml-2" name="city_type" id="cityType">
                                                    <option value="" {{ !$data->city_type ? 'selected' : '' }}>
                                                        {{ __('Select City Type') }}
                                                    </option>
                                                    <option value="city" {{ old('city_type', $data->is_top_city) == 0 ? 'selected' : '' }}>
                                                        Normal City
                                                    </option>
                                                    <option value="top_city" {{ old('city_type', $data->is_top_city) == 1 ? 'selected' : '' }}>
                                                        Top City
                                                    </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-6" >
                                            <div class="form-group">
                                                <label for="city">{{ __('City') }}</label>
                                                <input type="text" class="form-control" id="city" name="city"
                                                    placeholder="{{ __('Enter City Name') }}" value="{{ old('city', $data->city) }}">
                                            </div>
                                            @error('city')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Update') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const cityTypeSelect = document.getElementById('cityType');
            const cityField = document.getElementById('cityField');

            const toggleCityField = () => {
                const isTopCity = cityTypeSelect.value === 'top_city';
                if (isTopCity) {
                    cityField.classList.add('d-none');
                } else {
                    cityField.classList.remove('d-none');
                }
            };

            cityTypeSelect.addEventListener('change', toggleCityField);

            toggleCityField();
        });
    </script>
@endsection
