@extends('layouts.admin')

@section('content')
<div class="card">
    <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Manage Locations') }}</h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.locations.index') }}">{{ __('Locations') }}</a></li>
        </ol>
    </div>
</div>


    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
        <div class="card mb-4">
            <div class="table-responsive p-3">
                <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>{{ __('S.No.') }}</th>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('No. of Cities') }}</th>
                            <th>{{ __('Country') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($states as $index => $state)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $state->name }}</td>
                                <td>
                                    <a href="javascript:void(0);"
                                       class="cities-count"
                                       data-state-id="{{ $state->id }}"
                                       data-state-name="{{ $state->name }}">
                                       {{ $state->cities_count }}
                                    </a>
                                </td>
                                <td>{{ $state->country->name ?? 'N/A' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal for displaying cities -->
<div class="modal fade" id="citiesModal" tabindex="-1" aria-labelledby="citiesModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="citiesModalLabel">{{ __('Cities in') }} <span id="stateName"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <ul id="citiesList"></ul>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function () {
        // Handle click event on the "No. of Cities" column
        $('.cities-count').on('click', function () {
            var stateId = $(this).data('state-id');  // Get state ID from data attribute
            var stateName = $(this).data('state-name');  // Get state name from data attribute

            // Set the state name in the modal title
            $('#stateName').text(stateName);

            // Make an AJAX request to fetch cities for the clicked state
            $.ajax({
    url: '/admin/locations/cities/' + stateId,
    method: 'GET',
    success: function (data) {
        console.log(data); // Log the response to check the data structure

        // Empty the list first
        $('#citiesList').empty();

        if (data.cities && data.cities.length > 0) {
            data.cities.forEach(function (city) {
                $('#citiesList').append('<li>' + city.name + '</li>');
            });
        } else {
            $('#citiesList').append('<li>No cities found.</li>');
        }

        // Show the modal
        $('#citiesModal').modal('show');
    },
    error: function (xhr, status, error) {
        console.log(xhr.responseText);  // Log the error for debugging
        alert('Could not load cities.');
    }
});

        });
    });
</script>
@endsection
