@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Add New Plan') }} <a class="btn btn-primary btn-rounded btn-sm"
                    href="{{ route('admin.plans.index') }}"><i class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Manage Plan') }}</a></li>
            </ol>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Add New Plan Form') }}</h6>
                </div>

                <div class="card-body py-5">
                    <div class="gocover"
                        style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
                    </div>
                    <form class="" action="{{ route('admin.plans.store') }}" method="POST"
                        enctype="multipart/form-data">
                        @include('includes.admin.form-both')
                        {{ csrf_field() }}



                        <div class="card p-4">
                            <div class="row">
                                <div class="form-group col-md-10">
                                    <label for="user_type">{{ __('User Type') }}</label>
                                    <select name="user_type" class="form-control" id="user_type">
                                        <option value="owner">Property Owner</option>
                                        <option value="agent">Property Agent</option>
                                        <option value="builder/developer">Builder/Developer</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="property_type">{{ __('Property Type') }}</label>
                                    <select name="property_type" class="form-control" id="property_type">
                                        <option value="commercial">{{ __('Commercial') }}</option>
                                        <option value="residential">{{ __('Residential') }}</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="sale_type">{{ __('Sale Type') }}</label>
                                    <select name="sale_type" class="form-control" id="sale_type">
                                        <option value="for_sale" class="sale-option">{{ __('For Sell') }}</option>
                                        <option value="for_rent" class="rent-option">{{ __('For Rent') }}</option>
                                        <option value="for_pg" class="pg-option" style="display: none;">{{ __('For PG') }}
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card p-4 mt-3">
                            <div class="row">
                                <div class="form-group col-md-10">
                                    <label for="inp-title">{{ __('Title') }}</label>
                                    <input type="text" class="form-control" id="inp-title" name="title"
                                        placeholder="{{ __('Enter Title') }}" required>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="inp-subtitle">{{ __('Subtitle') }}</label>
                                    <input type="text" class="form-control" id="inp-subtitle" name="subtitle"
                                        placeholder="{{ __('Enter Subtitle') }}" required>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="plan_type">{{ __('Add Vaidity') }}</label>
                                    <select name="plan_type" class="form-control" id="plan_type">
                                        <option value="15">15 Days</option>
                                        <option value="30">30 Days</option>
                                        <option value="60">60 Days</option>
                                        <option value="90">90 Days</option>
                                        <option value="120">120 days</option>
                                        <option value="150">150 days</option>
                                        <option value="180">180 days</option>
                                        <option value="270">270 Days</option>
                                        <option value="365">1 year</option>
                                        <option value="730">2 years</option>
                                        <option value="1095">3 years</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="price">{{ __('Price') }} ({{ $currency->name }})</label>
                                    <input type="number" class="form-control" id="price" name="price"
                                        placeholder="{{ __('Plan Price') }}" min="0" step="0.01">
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="limit">{{ __('Ad Limit') }}</label>
                                    <input type="number" class="form-control" id="limit" name="post_limit"
                                        placeholder="0" min="0">
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="duration">{{ __('Ad Duration') }}</label>
                                    <input type="number" class="form-control" id="duration" name="post_duration"
                                        placeholder="0" min="0">
                                </div>
                                <div class="form-group col-md-10">
                                    <label for="slot">{{ __('Slot') }}</label>
                                    <select name="slot" class="form-control" id="slot">
                                        <option value="Top">Top Slot
                                        </option>
                                        <option value="Medium">Medium Slot
                                        </option>
                                    </select>
                                </div>
                                <div class="form-group col-md-10">
                                    <label for="boost">{{ __('Boost') }}</label>
                                    <select name="boost" class="form-control" id="boost">
                                        @for ($i = 1; $i <= 50; $i++)
                                            <option value="{{ $i }}">
                                                {{ $i }}X
                                            </option>
                                        @endfor
                                    </select>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="limit">{{ __('Price Color') }}</label>
                                    <div class="input-group">
                                        <input type="color" name="price_color" class="form-control"
                                            id="exampleInputPassword1">
                                    </div>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="status">{{ __('Status') }}</label>
                                    <select name="status" class="form-control" id="status">
                                        <option value="1">Activated</option>
                                        <option value="0">Deactivated</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        {{-- Extra section untouched --}}
                        <div class="featured-keyword-area">
                            <div class="lang-tag-top-filds" id="lang-section"></div>
                            <a href="javascript:;" id="lang-btn" class="add-fild-btn d-flex justify-content-center">
                                <i class="icofont-plus"></i> {{ __('Add Attribute') }}
                            </a>
                        </div>
                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                const userType = document.getElementById('user_type');
                                const propertyType = document.getElementById('property_type');
                                const saleTypeSelect = document.getElementById('sale_type');
                                const rentOption = saleTypeSelect.querySelector('.rent-option');
                                const pgOption = saleTypeSelect.querySelector('.pg-option');

                                function updateSaleOptions() {
                                    const selectedUser = userType.value;
                                    const selectedProperty = propertyType.value;

                                    // Default hide all
                                    rentOption.style.display = 'none';
                                    pgOption.style.display = 'none';

                                    if (selectedUser === 'builder/developer') {
                                        // Only For Sell
                                        saleTypeSelect.value = 'for_sale';
                                    } else {
                                        // Agent or Owner
                                        rentOption.style.display = 'block';

                                        if (selectedProperty === 'residential') {
                                            pgOption.style.display = 'block';
                                        } else {
                                            pgOption.style.display = 'none';

                                            // Reset PG if it was selected
                                            if (saleTypeSelect.value === 'for_pg') {
                                                saleTypeSelect.value = 'for_sale';
                                            }
                                        }
                                    }
                                }

                                // Initial run
                                updateSaleOptions();

                                // Watch changes
                                userType.addEventListener('change', updateSaleOptions);
                                propertyType.addEventListener('change', updateSaleOptions);
                            });
                        </script>
                        <div class="form-group col-md-10">
                            <input type="hidden" name="manage_schedule_id" value="" id="scheduleId">
                            <button type="submit" id="submit-btn"
                                class="btn btn-primary w-100 mt-3">{{ __('Submit') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script type="text/javascript">
        "use strict";

        function isEmpty(el) {
            return !$.trim(el.html())
        }

        $("#lang-btn").on('click', function() {

            $("#lang-section").append('' +
                '<div class="lang-area mb-3">' +
                '<span class="remove lang-remove"><i class="fas fa-times"></i></span>' +
                '<div class="row">' +
                '<div class="col-md-10">' +
                '<input type="text" class="form-control" name="attribute[]" placeholder="{{ __('Enter Plan Attribute') }}" value="" required>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '');

        });

        $(document).on('click', '.lang-remove', function() {

            $(this.parentNode).remove();

        });
    </script>
@endsection
