@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Edit Plan') }} <a class="btn btn-primary btn-rounded btn-sm"
                    href="{{ route('admin.plans.index') }}"><i class="fas fa-arrow-left"></i> {{ __('Back') }}</a></h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Manage Plan') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Edit Plan Form') }}</h6>
                </div>
                <div class="card-body py-5">
                    <div class="gocover"
                        style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
                    </div>
                    <form class="" action="{{ route('admin.plans.update', $data->id) }}" method="POST">
                        @include('includes.admin.form-both')
                        @csrf

                        {{-- ðŸ”· Card 1: User, Property, and Sale Type --}}
                        <div class="card p-4 mb-4">
                            <div class="row">
                                <div class="form-group col-md-10">
                                    <label for="user_type">{{ __('User Type') }}</label>
                                    <select name="user_type" class="form-control" id="user_type">
                                        <option value="owner" {{ $data->user_type == 'owner' ? 'selected' : '' }}>Property
                                            Owner</option>
                                        <option value="agent" {{ $data->user_type == 'agent' ? 'selected' : '' }}>Property
                                            Agent</option>
                                        <option value="builder/developer"
                                            {{ $data->user_type == 'builder/developer' ? 'selected' : '' }}>
                                            Builder/Developer</option>
                                    </select>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="property_type">{{ __('Property Type') }}</label>
                                    <select name="property_type" class="form-control" id="property_type">
                                        <option value="commercial"
                                            {{ $data->property_type == 'commercial' ? 'selected' : '' }}>Commercial
                                        </option>
                                        <option value="residential"
                                            {{ $data->property_type == 'residential' ? 'selected' : '' }}>Residential
                                        </option>
                                    </select>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="sale_type">{{ __('Sale Type') }}</label>
                                    <select name="sale_type" class="form-control" id="sale_type">
                                        <option value="for_sale" class="sale-option"
                                            {{ $data->sale_type == 'for_sale' ? 'selected' : '' }}>{{ __('For Sell') }}
                                        </option>
                                        <option value="for_rent" class="rent-option"
                                            {{ $data->sale_type == 'for_rent' ? 'selected' : '' }}>{{ __('For Rent') }}
                                        </option>
                                        <option value="for_pg" class="pg-option" style="display: none;"
                                            {{ $data->sale_type == 'for_pg' ? 'selected' : '' }}>{{ __('For PG') }}
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        {{-- ðŸ”· Card 2: Title to Status --}}
                        <div class="card p-4 mb-4">
                            <div class="row">
                                <div class="form-group col-md-10">
                                    <label for="inp-title">{{ __('Title') }}</label>
                                    <input type="text" class="form-control" id="inp-title" name="title"
                                        value="{{ $data->title }}" required>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="inp-subtitle">{{ __('Subtitle') }}</label>
                                    <input type="text" class="form-control" id="inp-subtitle" name="subtitle"
                                        value="{{ $data->subtitle }}" required>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="plan_type">{{ __('Add Vaidity') }}</label>
                                    <select name="plan_type" class="form-control" id="plan_type">
                                        <option value="15" {{ $data->plan_type == 15 ? 'selected' : '' }}>15 Days
                                        </option>
                                        <option value="30" {{ $data->plan_type == 30 ? 'selected' : '' }}>30 Days
                                        </option>
                                        <option value="60" {{ $data->plan_type == 60 ? 'selected' : '' }}>60 Days
                                        </option>
                                        <option value="90" {{ $data->plan_type == 90 ? 'selected' : '' }}>90 Days
                                        </option>
                                        <option value="120" {{ $data->plan_type == 120 ? 'selected' : '' }}>120 Days
                                        </option>
                                        <option value="150" {{ $data->plan_type == 150 ? 'selected' : '' }}>150 Days
                                        </option>
                                        <option value="180" {{ $data->plan_type == 180 ? 'selected' : '' }}>180 Days
                                        </option>
                                        <option value="180" {{ $data->plan_type == 180 ? 'selected' : '' }}>180 Days
                                        </option>
                                        <option value="270" {{ $data->plan_type == 270 ? 'selected' : '' }}>270 Days
                                        </option>
                                        <option value="365" {{ $data->plan_type == 365 ? 'selected' : '' }}>1 year
                                        </option>
                                        <option value="730" {{ $data->plan_type == 730 ? 'selected' : '' }}>2 years
                                        </option>
                                        <option value="1095" {{ $data->plan_type == 1095 ? 'selected' : '' }}>3 years
                                        </option>
                                    </select>
                                </div>
                                <div class="form-group col-md-10">
                                    <label for="price">{{ __('Price') }} ({{ $currency->name }})</label>
                                    <input type="number" class="form-control" id="price" name="price"
                                        value="{{ $data->price }}" min="0" step="0.01">
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="limit">{{ __('Ad Limit') }}</label>
                                    <input type="number" class="form-control" id="limit" name="post_limit"
                                        value="{{ $data->post_limit }}" min="0">
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="duration">{{ __('Ad Duration') }}</label>
                                    <input type="number" class="form-control" id="duration" name="post_duration"
                                        value="{{ $data->post_duration }}" min="0">
                                </div>
                                <div class="form-group col-md-10">
                                    <label for="slot">{{ __('Slot') }}</label>
                                    <select name="slot" class="form-control" id="slot">
                                        <option value="Top" {{ $data->slot == 'Top' ? 'selected' : '' }}>Top Slot</option>
                                        <option value="Medium" {{ $data->slot == 'Medium' ? 'selected' : '' }}>Medium Slot</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-10">
                                    <label for="boost">{{ __('Boost') }}</label>
                                    <select name="boost" class="form-control" id="boost">
                                        @for ($i = 1; $i <= 50; $i++)
                                            <option value="{{ $i }}" {{ $data->boost == $i ? 'selected' : '' }}>
                                                {{ $i }}X
                                            </option>
                                        @endfor
                                    </select>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="limit">{{ __('Price Color') }}</label>
                                    <div class="input-group">
                                        <input type="color" name="price_color" class="form-control"
                                            value="{{ $data->price_color }}" id="exampleInputPassword1">
                                    </div>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="status">{{ __('Status') }}</label>
                                    <select name="status" class="form-control" id="status">
                                        <option value="1" {{ $data->status == 1 ? 'selected' : '' }}>Activated
                                        </option>
                                        <option value="0" {{ $data->status == 0 ? 'selected' : '' }}>Deactivated
                                        </option>
                                    </select>
                                </div>

                                <div class="form-group col-md-10">
                                    <label for="attributes">{{ __('Attributes') }}</label>
                                    @if ($attributes)
                                        @foreach ($attributes as $key => $data)
                                            <div class="lang-area mb-3">
                                                <span class="remove lang-remove"><i class="fas fa-times"></i></span>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <input type="text" class="form-control" name="attribute[]"
                                                            placeholder="{{ __('Enter Plan Attribute') }}"
                                                            value="{{ $data }}" required>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>

                                <div class="form-group col-md-10">
                                    <div class="featured-keyword-area">
                                        <div class="lang-tag-top-filds" id="lang-section"></div>
                                        <a href="javascript:;" id="lang-btn"
                                            class="add-fild-btn d-flex justify-content-center">
                                            <i class="icofont-plus"></i> {{ __('Add Attribute') }}
                                        </a>
                                    </div>
                                </div>
                                <div class="form-group col-md-10">
                                    {{-- <input type="hidden" name="manage_schedule_id"
                                        value="{{ $data->manage_schedule_id }}" id="scheduleId"> --}}

                                    <button type="submit" id="submit-btn"
                                        class="btn btn-primary w-100 mt-3">{{ __('Update') }}</button>
                                </div>
                            </div>
                        </div>
                    </form>
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            const userType = document.getElementById('user_type');
                            const propertyType = document.getElementById('property_type');
                            const saleTypeSelect = document.getElementById('sale_type');
                            const rentOption = saleTypeSelect.querySelector('.rent-option');
                            const pgOption = saleTypeSelect.querySelector('.pg-option');

                            function updateSaleOptions() {
                                const selectedUser = userType.value;
                                const selectedProperty = propertyType.value;

                                rentOption.style.display = 'none';
                                pgOption.style.display = 'none';

                                if (selectedUser === 'builder/developer') {
                                    saleTypeSelect.value = 'for_sale';
                                } else {
                                    rentOption.style.display = 'block';

                                    if (selectedProperty === 'residential') {
                                        pgOption.style.display = 'block';
                                    } else {
                                        pgOption.style.display = 'none';
                                        if (saleTypeSelect.value === 'for_pg') {
                                            saleTypeSelect.value = 'for_sale';
                                        }
                                    }
                                }
                            }

                            updateSaleOptions();
                            userType.addEventListener('change', updateSaleOptions);
                            propertyType.addEventListener('change', updateSaleOptions);
                        });
                    </script>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script type="text/javascript">
        "use strict";

        function isEmpty(el) {
            return !$.trim(el.html())
        }


        $("#lang-btn").on('click', function() {

            $("#lang-section").append('' +
                '<div class="lang-area mb-3">' +
                '<span class="remove lang-remove"><i class="fas fa-times"></i></span>' +
                '<div class="row">' +
                '<div class="col-md-12">' +
                '<input type="text" class="form-control" name="attribute[]" placeholder="{{ __('Enter Plan Attribute') }}" value="" required>' +
                '</div>' +
                '</div>' +
                '</div>' +
                '');

        });

        $(document).on('click', '.lang-remove', function() {

            $(this.parentNode).remove();

        });
    </script>
@endsection
