@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Manage All Packages') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Manage All Packages') }}</a></li>
            </ol>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            <div class="row mb-3">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <small>From Date</small>
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                        </div>
                                        <input type="date" id="from_date" class="form-control form-control-sm calender"
                                            placeholder="From Date">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <small>To Date</small>
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                        </div>
                                        <input type="date" id="to_date" class="form-control form-control-sm calender"
                                            placeholder="To Date">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2 mt-4">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="user_type" class="form-control form-control-sm">
                                            <option value="" selected>Select User Type</option>
                                            <option value="owner">Property Owner</option>
                                            <option value="agent">Property Agent</option>
                                            <option value="builder/developer"> Builder/Developer</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2 mt-4">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="property_type" class="form-control form-control-sm">
                                            <option value="" selected>Select Property Type</option>
                                            <option value="commercial">Commercial</option>
                                            <option value="residential">Residential</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2 mt-4">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="sale_type" class="form-control form-control-sm">
                                            <option value="" selected>Select Sale Type</option>
                                            <option value="for_sell">For Sell</option>
                                            <option value="for_rent">For Rent</option>
                                            <option value="for_pg">For PG</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-2 d-flex align-items-center">
                                    <button id="filter_button" class="btn btn-primary btn-sm mr-2">Filter</button>
                                    <button id="reset_button" class="btn btn-secondary btn-sm">Reset</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive table-smaller" cellspacing="0"
                        width="100%">
                        <thead class="thead-light">
                            <tr>
                                <th>{{ __('S.No.') }}</th>
                                <th>{{ __('Create Date') }}</th>
                                <th>{{ __('User Type') }}</th>
                                <th>{{ __('Sale Type') }}</th>
                                <th>{{ __('Title') }}</th>
                                <th>{{ __('Price') }}</th>
                                <th>{{ __('Listing Limit') }}</th>
                                <th>{{ __('Listing Duration') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Options') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>


    @includeIf('partials.admin.status')
    <div class="modal fade confirm-modal" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Confirm Delete') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">
                        {{ __('You are about to delete this plan. Every informtation under this plan will be deleted.') }}
                    </p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-danger btn-ok">{{ __('Delete') }}</a>
                </div>
            </div>
        </div>
    </div>
@endsection



@section('scripts')
    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: {
                url: '{{ route('admin.plans.datatables') }}',
                data: function(d) {
                    d.from_date = $('#from_date').val();
                    d.to_date = $('#to_date').val();
                    d.user_type = $('#user_type').val();
                    d.sale_type = $('#sale_type').val();
                    d.property_type = $('#property_type').val();
                }
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'user_type',
                    name: 'user_type'
                },
                {
                    data: 'sale_type',
                    name: 'sale_type'
                },
                {
                    data: 'title',
                    name: 'title'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'post_limit',
                    name: 'post_limit'
                },
                {
                    data: 'post_duration',
                    name: 'post_duration'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'action',
                    searchable: false,
                    orderable: false
                }

            ],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            }
        });

        // Handle filter button click
        $('#filter_button').on('click', function() {
            table.ajax.reload();
        });

        // Handle reset button click
        $('#reset_button').on('click', function() {
            $('#from_date').val('');
            $('#to_date').val('');
            $('#user_type').val('');
            $('#sale_type').val('');
            $('#property_type').val('');
            table.ajax.reload();
        });
        $(function() {
            $(".btn-area").append('<div class="col-sm-12 col-md-4 pr-3 text-right">' +
                '<a class="btn btn-primary" href="{{ route('admin.plans.create') }}">' +
                '<i class="fas fa-plus"></i> {{ __('Add New') }}' +
                '</a>' +
                '</div>');
        });
    </script>
@endsection
