@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Package History') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Package History') }}</a></li>
            </ol>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-lg-12">
            <div class="row mb-3">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    {{-- <small>From Date</small> --}}
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                        </div>
                                        <input type="date" id="from_date" class="form-control form-control-sm calender"
                                            placeholder="From Date">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    {{-- <small>To Date</small> --}}
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                        </div>
                                        <input type="date" id="to_date" class="form-control form-control-sm calender"
                                            placeholder="To Date">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="user_type" class="form-control form-control-sm">
                                            <option value="" selected>Select User Type</option>
                                            <option value="owner">Property Owner</option>
                                            <option value="agent">Property Agent</option>
                                            <option value="builder/developer"> Builder/Developer</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="property_type" class="form-control form-control-sm">
                                            <option value="" selected>Select Property Type</option>
                                            <option value="commercial">Commercial</option>
                                            <option value="residential">Residential</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="sale_type" class="form-control form-control-sm">
                                            <option value="" selected>Select Sale Type</option>
                                            <option value="for_sell">For Sell</option>
                                            <option value="for_rent">For Rent</option>
                                            <option value="for_pg">For PG</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="plan_id" class="form-control form-control-sm">
                                            <option value="" selected>Select Package</option>
                                            @foreach ($plans as $plan)
                                                <option value="{{ $plan->id }}">{{ $plan->title }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="plan_type" class="form-control form-control-sm">
                                            <option value="" selected>Select Plan Type</option>
                                            <option value="15">15 days</option>
                                            <option value="30">30 days</option>
                                            <option value="60">60 days</option>
                                            <option value="90">90 days</option>
                                            <option value="120">120 days</option>
                                            <option value="150">150 days</option>
                                            <option value="180">180 days</option>
                                            <option value="365">1 year</option>
                                            <option value="730">2 years</option>
                                            <option value="1095">3 years</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="input-group mb-2">
                                        <div class="input-group-prepend ">
                                            <span class="input-group-text"><i class="fas fa-user"></i></span>
                                        </div>
                                        <select id="status" class="form-control form-control-sm">
                                            <option value="" selected>Select Status</option>
                                            <option value="">All</option>
                                            <option value="1">Active</option>
                                            <option value="0">Expired</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2 d-flex align-items-center">
                                    <button id="filter_button" class="btn btn-primary btn-sm mr-2">Filter</button>
                                    <button id="reset_button" class="btn btn-secondary btn-sm">Reset</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive table-smaller" cellspacing="0"
                        width="100%">
                        <thead class="thead-light">
                            <tr>
                                <th>{{ __('S.No.') }}</th>
                                <th>{{ __('Package Name') }}</th>
                                <th>{{ __('Asigned To') }}</th>
                                <th>{{ __('User Type') }}</th>
                                <th>{{ __('Sale Type') }}</th>
                                <th>{{ __('Amount') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Active Date') }}</th>
                                <th>{{ __('Expire Date') }}</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th colspan="5" style="text-align:right">Total:</th>
                                <th id="amount_total"></th>
                                <th colspan="3"></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script type="text/javascript">
        "use strict";
        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: {
                url: '{{ route('admin.ex.plans.datatables') }}',
                data: function(d) {
                    d.from_date = $('#from_date').val();
                    d.to_date = $('#to_date').val();
                    d.user_type = $('#user_type').val();
                    d.property_type = $('#property_type').val();
                    d.sale_type = $('#sale_type').val();
                    d.plan_id = $('#plan_id').val();
                    d.plan_type = $('#plan_type').val();
                    d.status = $('#status').val();

                }
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'plan.package_name',
                    name: 'plan.package_name'
                },
                {
                    data: 'assigned_user_name',
                    name: 'assigned_user_name'
                },
                {
                    data: 'user_type',
                    name: 'user_type'
                },
                {
                    data: 'sale_type',
                    name: 'sale_type'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'status',
                    name: 'status',
                    render: function(data, type, row) {
                        return data == 1 ? '<span class="badge bg-success text-white">Active</span>' :
                            '<span class="badge bg-danger text-white">Expired</span>';
                    }
                },
                {
                    data: 'active_date',
                    name: 'active_date'
                },
                {
                    data: 'expire_date',
                    name: 'expire_date'
                }
            ],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            },
            footerCallback: function(row, data, start, end, display) {
                var api = this.api();
                // Remove formatting to get integer data for summation
                var intVal = function(i) {
                    return typeof i === 'string' ?
                        i.replace(/[\₹,]/g, '') * 1 :
                        typeof i === 'number' ?
                        i : 0;
                };
                // Total over all pages
                var total = api
                    .column(5, {
                        search: 'applied'
                    })
                    .data()
                    .reduce(function(a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);
                // Update footer
                $(api.column(5).footer()).html('₹' + total.toLocaleString());
            }
        });
        // Handle filter button click
        $('#filter_button').on('click', function() {
            table.ajax.reload();
        });
        // Handle reset button click
        $('#reset_button').on('click', function() {
            $('#from_date').val('');
            $('#to_date').val('');
            $('#user_type').val('');
            $('#property_type').val('');
            $('#sale_type').val('');
            $('#plan_id').val('');
            $('#plan_type').val('');
            $('#status').val('');
            table.ajax.reload();
        });
    </script>
@endsection
