@extends('layouts.admin')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@section('styles')
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form method="POST"
                action="{{ isset($property->id) ? route('admin.properties.store_plots', ['id' => $property->id]) : route('admin.properties.store_plots') }}">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-12">
                        <x-normal-input label="Name" name="name" type="text" placeholder="Property Name"
                            :value="old('name', $property->name ?? '')" />

                        <x-area-with-unit areaLabel="Plot Area" unitLabel="Select Unit" :showDimensions="true" :selectedArea="old('plot_area', $property->plot_area ?? '')"
                            :selectedUnit="old('area_unit', $property->area_unit ?? '')" :selectedLength="old('plot_length', $property->plot_length ?? '')" :selectedWidth="old('plot_width', $property->plot_width ?? '')" id="main-area-unit" />


                        <x-normal-input label="Floors Allowed for Construction" type="number" id="floors_input"
                            name="floors_allowed" placeholder="Enter the number of allowed floors" :value="old('floors_allowed', $property->floors_allowed ?? '')" />

                        <x-radio-group name="boundary_wall" label="Is there a boundary wall around?" :options="['yes' => 'Yes', 'no' => 'No']"
                            :selected="old('boundary_wall', $property->boundary_wall ?? null)" />

                        <x-radio-group label="No. of Open Sides" name="open_sides" :options="['1', '2', '3', '3+']" :selected="old('open_sides', $property->open_sides ?? null)" />

                        <x-radio-group label="Any Construction Done on this Property?" name="construction_done"
                            :options="['yes' => 'Yes', 'no' => 'No']" :selected="old('construction_done', isset($property) ? $property->construction_done : '')" />

                        <x-radio-group label="Type of Construction" name="construction_type" :options="['shed' => 'Shed', 'rooms' => 'Room(s)', 'others' => 'Others']"
                            :selected="old('construction_type', $property->construction_type ?? null)" />

                        <div class="card my-1">
                            <div class="card-body">
                                <div class="col-md-10">
                                    <h6 class="my-2">{{ __('Possession Status') }}</h6>
                                    <div class="form-group">
                                        @foreach (['immediate' => 'Immediate', 'future' => 'In Future'] as $val => $label)
                                            <input type="radio" id="possession_{{ $val }}"
                                                name="possession_status" value="{{ $val }}"
                                                onchange="togglePossessionDate()"
                                                {{ old('possession_status', $property->possession_status ?? '') == $val ? 'checked' : '' }}>
                                            <label for="possession_{{ $val }}"
                                                class="me-3">{{ $label }}</label>
                                        @endforeach
                                    </div>
                                    @error('possession_status')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                                <div id="possession_date_group" style="display: none;">
                                    <h6 class="m-0">{{ __('Possesion Date') }}</h6><br>
                                    <div class="form-group w-25">
                                        <input type="date" name="possession_date" class="form-control calender"
                                            value="{{ old('possession_date', $property->possession_date ?? '') }}">
                                    </div>
                                    @error('possession_date')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <x-near-by-field label="Nearby Plots" :facilities="$facilities ?? []" :facilityDistances="$facility_distances ?? []" />

                        <x-radio-group label="Ownership" name="ownership" :options="[
                            'pre-holder' => 'Pre-Holder',
                            'lease-holder' => 'Lease-Holder',
                            'co-operative-society' => 'Co-Operative Society',
                            'power-of-attorney' => 'Power of Attorney',
                        ]" :selected="old('ownership', $property->ownership ?? null)" />

                        <x-normal-input label="Property Expected Price ( in Rs )" name="price" type="number"
                            placeholder="" :value="old('price', $property->price ?? '')" />

                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('admin.properties.step_1', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn" class="btn btn-primary">{{ __('Next') }}</button>
                        </div>
                    </div>
            </form>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script>
        function togglePossessionDate() {
            const futureRadio = document.getElementById('possession_future');
            const dateGroup = document.getElementById('possession_date_group');

            if (futureRadio.checked) {
                dateGroup.style.display = 'block';
            } else {
                dateGroup.style.display = 'none';
            }
        }
        window.addEventListener('DOMContentLoaded', togglePossessionDate);
    </script>
@endsection
