@extends('layouts.admin')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    input[type="radio"] {
        display: none;
    }

    input[type="radio"]+label {
        display: inline-block;
        margin: 5px;
        padding: 5px 10px;
        background-color: #f8f9fa;
        border: 1px solid #ddd;
        border-radius: 5px;
        cursor: pointer;
    }

    label:hover {
        background-color: #f0f0f0;
    }

    input[type="radio"]:checked+label {
        background-color: #007bff;
        color: #fff;
        border-color: #007bff;
    }

    input[type="radio"]:hidden+.parking-label {
        background-color: #e9ecef;
        color: #000;
    }

    input[type="radio"]:checked+.parking-label {
        background-color: #007bff;
        color: #fff;
        border-color: #0056b3;
    }

    .custom-control-input {
        display: none;
    }

    .steps-container {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        padding: 0 15px;
    }
    
    .step-item {
        display: flex;
        align-items: center;
        position: relative;
        margin: 5px 0;
    }
    
    .step-circle {
        min-width: 30px;
        height: 30px;
        border-radius: 50%;
        background-color: #ddd;
        color: #555;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        font-weight: bold;
        text-decoration: none;
        z-index: 2;
    }
    
    .step-circle.active {
        background-color: #007bff;
        color: white;
    }
    
    .step-label {
        margin: 0 8px;
        white-space: nowrap;
        font-size: 14px;
    }
    
    .step-line {
        height: 4px;
        background-color: #ddd;
        flex: 1;
        min-width: 20px;
        max-width: 50px;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .steps-container {
            flex-direction: column;
            align-items: flex-start;
            max-width: 100%;
        }
        
        .step-item {
            width: 100%;
            margin-bottom: 15px;
        }
        
        .step-line {
            position: absolute;
            left: 15px;
            top: 30px;
            width: 4px;
            height: 20px;
            min-width: 4px;
        }
        
        .step-label {
            margin-left: 15px;
        }
        
        .step-item:last-child .step-line {
            display: none;
        }
    }
    
    /* Medium screens */
    @media (min-width: 769px) and (max-width: 991px) {
        .step-label {
            font-size: 12px;
        }
        
        .step-line {
            min-width: 15px;
            max-width: 30px;
        }
    }
</style>
@section('content')
<div class="card">
    <div class="d-flex justify-content-center">
        @php
            $steps = [
                1 => 'Basic Details',
                2 => 'Property Details',
                3 => 'Location Details',
                4 => 'Photos & Videos',
            ];
            $currentStep = request()->route()->getName();
            preg_match('/step_(\d+)/', $currentStep, $matches);
            $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
        @endphp
        <div class="steps-container my-1">
            @foreach ($steps as $step => $label)
                <div class="step-item">
                    <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                        {{ $step }}
                    </a>
                    <span class="step-label">{{ $label }}</span>
                    @if ($step < count($steps))
                        <div class="step-line"></div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</div>
<div class="row justify-content-center mt-3">
    <div class="card p-4 col-md-12">
        <form id="addressForm"
            action="{{ isset($property->id) ? route('admin.properties.store_step_3', ['id' => $property->id]) : route('admin.properties.store_step_3') }}"
            method="POST">
            {{ csrf_field() }}
            <div class="mb-3">
                <label class="form-label">City</label>
                <select class="form-select" id="citySelect" name="location_id" required>
                    <option value="">Select city</option>
                    @foreach ($locations as $location)
                    <option value="{{ $location->id }}"
                        @if (isset($property->city) && $property->city == $location->city) selected @endif>
                        {{ $location->city }}
                    </option>
                    @endforeach
                </select>
            </div>

            <div class="mb-3 position-relative">
                <label class="form-label">Building / Apartment / Society Name *</label>
                <input type="text" class="form-control" id="buildingInput" name="building"
                    value="{{ isset($property->building) ? $property->building : '' }}" required>
                <div class="spinner-border text-primary loading-spinner" id="loadingSpinner"></div>
                <div class="suggestions-list" id="suggestionsList"></div>
            </div>

            <div id="additionalFields">
                <div class="mb-3" id="localityGroup">
                    <label class="form-label">Locality / Sector *</label>
                    <input type="text" class="form-control" id="localityInput" name="locality"
                        value="{{ isset($property->locality) ? $property->locality : '' }}">
                </div>
                <div class="mb-3" id="sublocalityGroup">
                    <label class="form-label">Sublocality / Area / Street</label>
                    <input type="text" class="form-control" id="sublocalityInput" name="sub_locality"
                        value="{{ isset($property->sub_locality) ? $property->sub_locality : '' }}">
                </div>
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.properties.step_2', $property->id ?? null) }}" id="back-btn" class="btn btn-secondary">{{ __('Back') }}</a>
                    <button type="submit" id="submit-btn" class="btn btn-primary">{{ __('Next') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@section('scripts')
<script>
    let debounceTimer;
    const citySelect = document.getElementById('citySelect');
    const buildingInput = document.getElementById('buildingInput');
    const suggestionsList = document.getElementById('suggestionsList');
    const loadingSpinner = document.getElementById('loadingSpinner');
    const additionalFields = document.getElementById('additionalFields');
    const localityInput = document.getElementById('localityInput');
    const sub_localityInput = document.getElementById('sublocalityInput');

    citySelect.addEventListener('change', function() {
        buildingInput.disabled = !this.value;
        buildingInput.value = '';
        suggestionsList.style.display = 'none';
        showAdditionalFields();
    });

    buildingInput.addEventListener('input', function(e) {
        clearTimeout(debounceTimer);
        const query = e.target.value.trim();
        const selectedCity = citySelect.value;

        if (!query || query.length < 3 || !selectedCity) {
            suggestionsList.style.display = 'none';
            return;
        }

        debounceTimer = setTimeout(async () => {
            loadingSpinner.style.display = 'inline-block';
            try {
                const response = await fetch(
                    `https://nominatim.openstreetmap.org/search?q=${encodeURIComponent(
                    query
                )}+${encodeURIComponent(selectedCity)}&format=json&addressdetails=1&limit=5`
                );
                const data = await response.json();
                displaySuggestions(data);
            } catch (error) {
                console.error('Error fetching suggestions:', error);
            }
            loadingSpinner.style.display = 'none';
        }, 300);
    });

    function displaySuggestions(suggestions) {
        suggestionsList.innerHTML = '';

        if (!suggestions || suggestions.length === 0) {
            const noResult = document.createElement('div');
            noResult.className = 'suggestion-item text-muted';
            noResult.textContent = 'No results found.';
            suggestionsList.appendChild(noResult);
            suggestionsList.style.display = 'block';
            return;
        }

        suggestions.forEach(suggestion => {
            const div = document.createElement('div');
            div.className = 'suggestion-item';
            div.textContent = suggestion.display_name;
            div.addEventListener('click', () => handleSuggestionClick(suggestion));
            suggestionsList.appendChild(div);
        });

        suggestionsList.style.display = 'block';
    }


    function handleSuggestionClick(suggestion) {
        buildingInput.value = suggestion.display_name;
        suggestionsList.style.display = 'none';

        const address = suggestion.address;
        const hasCompleteAddress = address &&
            (address.road || address.suburb || address.neighbourhood || address.residential);

        if (hasCompleteAddress) {
            localityInput.value = address.suburb || address.neighbourhood || address.road || '';
            sub_localityInput.value = address.road || address.suburb || address.neighbourhood || '';

            console.log('Locality:', localityInput.value);
            console.log('Sublocality:', sub_localityInput.value);

            additionalFields.style.display = 'none';
            localityInput.required = false;
        } else {
            showAdditionalFields();
        }
    }

    function showAdditionalFields() {
        additionalFields.style.display = 'block';
        localityInput.required = true;
        localityInput.value = '';
        sublocalityInput.value = '';
    }

    document.addEventListener('click', function(e) {
        if (!suggestionsList.contains(e.target) && e.target !== buildingInput) {
            suggestionsList.style.display = 'none';
        }
    });
    function cleanAddressInput(input) {
    // remove space before comma
    input = input.replace(/\s+,/g, ',');

    // ensure exactly one space after comma
    input = input.replace(/,\s*/g, ', ');

    return input.trim();
}

document.getElementById('address').addEventListener('blur', function () {
    this.value = cleanAddressInput(this.value);
});
</script>
@endsection