@extends('layouts.admin')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    input[type="radio"] {
        display: none;
    }

    input[type="radio"]+label {
        display: inline-block;
        margin: 5px;
        padding: 5px 10px;
        background-color: #f8f9fa;
        border: 1px solid #ddd;
        border-radius: 5px;
        cursor: pointer;
    }

    label:hover {
        background-color: #f0f0f0;
    }

    input[type="radio"]:checked+label {
        background-color: #007bff;
        color: #fff;
        border-color: #007bff;
    }

    input[type="radio"]:hidden+.parking-label {
        background-color: #e9ecef;
        color: #000;
    }

    input[type="radio"]:checked+.parking-label {
        background-color: #007bff;
        color: #fff;
        border-color: #0056b3;
    }

    .custom-control-input {
        display: none;
    }

    .steps-container {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        padding: 0 15px;
    }

    .step-item {
        display: flex;
        align-items: center;
        position: relative;
        margin: 5px 0;
    }

    .step-circle {
        min-width: 30px;
        height: 30px;
        border-radius: 50%;
        background-color: #ddd;
        color: #555;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        font-weight: bold;
        text-decoration: none;
        z-index: 2;
    }

    .step-circle.active {
        background-color: #007bff;
        color: white;
    }

    .step-label {
        margin: 0 8px;
        white-space: nowrap;
        font-size: 14px;
    }

    .step-line {
        height: 4px;
        background-color: #ddd;
        flex: 1;
        min-width: 20px;
        max-width: 50px;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .steps-container {
            flex-direction: column;
            align-items: flex-start;
            max-width: 100%;
        }

        .step-item {
            width: 100%;
            margin-bottom: 15px;
        }

        .step-line {
            position: absolute;
            left: 15px;
            top: 30px;
            width: 4px;
            height: 20px;
            min-width: 4px;
        }

        .step-label {
            margin-left: 15px;
        }

        .step-item:last-child .step-line {
            display: none;
        }
    }

    /* Medium screens */
    @media (min-width: 769px) and (max-width: 991px) {
        .step-label {
            font-size: 12px;
        }

        .step-line {
            min-width: 15px;
            max-width: 30px;
        }
    }
</style>
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form class="" id="property-form"
                action="{{ isset($property->id) ? route('admin.properties.store_step_4', ['id' => $property->id]) : route('admin.properties.store_step_4') }}"
                method="POST" enctype="multipart/form-data">
                <!-- @include('includes.admin.form-both') -->
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card my-1">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Property Images') }}</h6>
                            </div>
                            <div class="card-body">
                                <!-- Property Covered Image -->
                                <div class="form-group">
                                    <div class="py-3 d-flex  justify-content-between">
                                        <h6 class="m-0">{{ __('Property Covered Image') }}</h6>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="wrapper-image-preview">
                                                <div class="box">
                                                    <div class="back-preview-image"
                                                        style="background-image: url({{ $property->photo ? asset('assets/images/' . $property->photo) : asset('assets/images/placeholder.jpg') }});">
                                                    </div>
                                                    <div class="upload-options">
                                                        <label class="img-upload-label" for="img-upload">
                                                            <i class="fas fa-camera"></i> {{ __('Upload Picture') }}
                                                        </label>
                                                        <input id="img-upload" type="file" class="image-upload"
                                                            name="photo" accept="image/*">
                                                    </div>
                                                </div>
                                            </div>
                                            @if ($errors->has('photo'))
                                                <span class="text-danger">{{ $errors->first('photo') }}</span>
                                            @endif
                                        </div>
                                        <!-- Rejection Reason Input -->
                                        <div class="col-md-6">
                                            <div class="rejection-form-wrapper">
                                                <!-- Hidden fields for AJAX -->
                                                <input type="hidden" id="rejection-form-url"
                                                    value="{{ route('set.rejection.msg', ['id' => $property->id ?? null]) }}">
                                                <input type="hidden" id="property-id" value="{{ $property->id ?? '' }}">

                                                <div class="form-group">
                                                    <label
                                                        for="reason">{{ __('❎ Set Rejection Reason or Message (if any)') }}</label>

                                                    @php
                                                        $commonReasons = [
                                                            'Blurry or low-quality image',
                                                            'Incorrect or misleading photo',
                                                            'Watermarked or copyrighted image',
                                                            'Inappropriate images',
                                                            'Duplicate images',
                                                        ];

                                                        $selectedReasons = old('reason', $re_message?->reason);

                                                        // Normalize to array
                                                        if (!is_array($selectedReasons)) {
                                                            $selectedReasons = $selectedReasons
                                                                ? [$selectedReasons]
                                                                : [];
                                                        }

                                                        // Extract any custom reason not in common list
                                                        $customReason = collect($selectedReasons)
                                                            ->filter(fn($r) => !in_array($r, $commonReasons))
                                                            ->first();
                                                    @endphp

                                                    {{-- Common Reasons as Checkboxes --}}
                                                    <div class="mt-2 mb-3">
                                                        @foreach ($commonReasons as $reason)
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="checkbox"
                                                                    name="reason[]" id="reason_{{ Str::slug($reason) }}"
                                                                    value="{{ $reason }}"
                                                                    {{ in_array($reason, $selectedReasons) ? 'checked' : '' }}>
                                                                <label class="form-check-label"
                                                                    for="reason_{{ Str::slug($reason) }}">
                                                                    {{ $reason }}
                                                                </label>
                                                            </div>
                                                        @endforeach
                                                    </div>

                                                    {{-- Optional Custom Reason --}}
                                                    <div class="form-group mt-3">
                                                        <label for="custom_reason">Or write a custom reason</label>
                                                        <input type="text" name="reason[]" id="custom_reason"
                                                            class="form-control mt-1" placeholder="Enter custom reason"
                                                            value="{{ $customReason }}">
                                                    </div>
                                                </div>

                                                <div class="justify-content-center mt-3 my-1">
                                                    <button type="button" class="btn btn-primary"
                                                        id="submit-reason-btn">{{ __('Submit') }}</button>
                                                </div>
                                            </div>
                                        </div>
                                        @if ($deleted_images->count())
                                            <div class="alert alert-warning">
                                                <strong>Warning!</strong> These images are deleted. You can restore or
                                                delete
                                                them permanently.
                                            </div>
                                            <div class="row">
                                                @php
                                                    $firstImage = $deleted_images->first();
                                                    $firstImageId = $firstImage ? $firstImage->id : null;
                                                    $firstImagePhoto = $firstImage ? $firstImage->photo : '';
                                                    $restoreUrl = url('/admin/gallery/' . $firstImageId . '/restore');
                                                    $deleteUrl = url(
                                                        '/admin/gallery/' . $firstImageId . '/force-delete',
                                                    );
                                                @endphp

                                                @if ($firstImageId)
                                                    <form action="{{ $restoreUrl }}" method="POST"
                                                        style="display:inline;">
                                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                    </form>
                                                @endif
                                                @foreach ($deleted_images as $image)
                                                    <div class="col-md-4">
                                                        <img src="{{ asset('assets/images/' . $image->photo) }}"
                                                            class="img-thumbnail mb-2" alt="Deleted Image">

                                                        <form action="{{ route('gallery.restore', $image->id) }}"
                                                            method="POST" style="display:inline;">
                                                            @csrf
                                                            <button type="submit"
                                                                class="btn btn-success btn-sm">Restore</button>
                                                        </form>

                                                        <form action="{{ route('gallery.forceDelete', $image->id) }}"
                                                            method="POST" style="display:inline;">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger btn-sm">Delete
                                                                Permanently</button>
                                                        </form>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                </div>
                                <!-- Property Image Gallery -->
                                <div class="form-group">
                                    <span class="text-primary">Minimum 4 images are mandatory</span><br>
                                    <button type="button" class="btn btn-secondary set-gallery" data-toggle="modal"
                                        data-target="#setgallery" id="myBtn">
                                        <i class="icofont-plus"></i> {{ __('Upload Property Image Gallery') }}
                                    </button>
                                </div>
                                <div id="error-message" class="text-danger" style="display: none;">
                                    Your uploaded images is still less than 4 please upload atleast 4 images.
                                </div>
                            </div>
                        </div>

                        <div class="card my-1">
                            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                <h6>{{ __('Floor Plans') }}</h6>
                            </div>
                            <div class="card-body">
                                <div id="floor-plans-container">
                                    @if ($floor_plans->isEmpty())
                                        <!-- Add empty floor plan fields if no floor plans are available -->
                                        <div class="row floor-plan-field align-items-center">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <input type="hidden" name="floor_id[]" value="">
                                                    <input type="text" class="form-control" name="floor_names[]"
                                                        placeholder="{{ __('Floor Name (E.g: Ground Floor...)') }}">
                                                    @error('floor_names.*')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <select class="form-control" name="floor_sizes[]" required>
                                                        <option value="" disabled selected>{{ __('Select Type') }}
                                                        </option>
                                                        <option value="1 RK">1 RK</option>
                                                        <option value="1 BHK">1 BHK</option>
                                                        <option value="1.5 BHK">1.5 BHK</option>
                                                        <option value="2 BHK">2 BHK</option>
                                                        <option value="2.5 BHK">2.5 BHK</option>
                                                        <option value="3 BHK">3 BHK</option>
                                                        <option value="3.5 BHK">3.5 BHK</option>
                                                        <option value="4 BHK">4 BHK</option>
                                                        <option value="4.5 BHK">4.5 BHK</option>
                                                        <option value="5 BHK">5 BHK</option>
                                                        <option value="5.5 BHK">5.5 BHK</option>
                                                        <option value="6 BHK">6 BHK</option>
                                                        <option value="6.5 BHK">6.5 BHK</option>
                                                        <option value="7 BHK">7 BHK</option>
                                                        <option value="7+ BHK">7+ BHK</option>
                                                    </select>
                                                    @error('floor_sizes.*')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group mt-2">
                                                    <input type="file" class="form-control" name="floor_images[]"
                                                        accept="image/*" required>
                                                    @error('floor_images.*')
                                                        <small class="text-danger">{{ $message }}</small>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <!-- Display the existing floor plans -->
                                        @foreach ($floor_plans as $key => $f_plan)
                                            <div class="row floor-plan-field align-items-center">
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <input type="hidden" name="floor_id[]"
                                                            value="{{ $f_plan->id }}">
                                                        <input type="text" class="form-control" name="floor_names[]"
                                                            placeholder="{{ __('Floor Name (E.g: Ground Floor...)') }}"
                                                            value="{{ old('floor_names.' . $key, $f_plan->name) }}"
                                                            required>
                                                        @error("floor_names.$key")
                                                            <small class="text-danger">{{ $message }}</small>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <select class="form-control" name="floor_sizes[]" required>
                                                            <option value="" disabled>{{ __('Select Type') }}
                                                            </option>
                                                            <option value="1 RK" @selected($f_plan->size == '1 RK')>1 RK
                                                            </option>
                                                            <option value="1 BHK" @selected($f_plan->size == '1 BHK')>1 BHK
                                                            </option>
                                                            <option value="1.5 BHK" @selected($f_plan->size == '1.5 BHK')>1.5 BHK
                                                            </option>
                                                            <option value="2 BHK" @selected($f_plan->size == '2 BHK')>2 BHK
                                                            </option>
                                                            <option value="2.5 BHK" @selected($f_plan->size == '2.5 BHK')>2.5 BHK
                                                            </option>
                                                            <option value="3 BHK" @selected($f_plan->size == '3 BHK')>3 BHK
                                                            </option>
                                                            <option value="3.5 BHK" @selected($f_plan->size == '3.5 BHK')>3.5 BHK
                                                            </option>
                                                            <option value="4 BHK" @selected($f_plan->size == '4 BHK')>4 BHK
                                                            </option>
                                                            <option value="4.5 BHK" @selected($f_plan->size == '4.5 BHK')>4.5 BHK
                                                            </option>
                                                            <option value="5 BHK" @selected($f_plan->size == '5 BHK')>5 BHK
                                                            </option>
                                                            <option value="5.5 BHK" @selected($f_plan->size == '5.5 BHK')>5.5 BHK
                                                            </option>
                                                            <option value="6 BHK" @selected($f_plan->size == '6 BHK')>6 BHK
                                                            </option>
                                                            <option value="6.5 BHK" @selected($f_plan->size == '6.5 BHK')>6.5 BHK
                                                            </option>
                                                            <option value="7 BHK" @selected($f_plan->size == '7 BHK')>7 BHK
                                                            </option>
                                                            <option value="7+ BHK" @selected($f_plan->size == '7+ BHK')>7+ BHK
                                                            </option>
                                                        </select>
                                                        @error("floor_sizes.$key")
                                                            <small class="text-danger">{{ $message }}</small>
                                                        @enderror
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="back-preview-image"
                                                        style="background-image: url({{ $f_plan->photo ? asset('assets/images/' . $f_plan->photo) . '?t=' . time() : asset('assets/images/placeholder.jpg') }});">
                                                    </div>
                                                    <div class="form-group mt-2">
                                                        <input type="file" class="form-control floor-image-input"
                                                            name="floor_images[]" accept="image/*" id="floorImageInput"
                                                            @if (!$f_plan->photo) required @endif>
                                                        @if (!$f_plan->photo)
                                                            @error("floor_images.$key")
                                                                <small class="text-danger">{{ $message }}</small>
                                                            @enderror
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                </div>
                                <div class="row" style="margin-top: 15px;">
                                    <div class="col-12">
                                        <button type="button" class="btn btn-secondary set-gallery"
                                            id="add-new-floor-plan-btn">Add New</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <a href="{{ route('admin.properties.step_3', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary">{{ __('Back') }}</a>&nbsp; &nbsp;
                            <button type="submit" id="submit-btn" class="btn btn-primary">{{ __('Submit') }}</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>
    </div>

    <div class="modal fade" id="setgallery" tabindex="-1" role="dialog" aria-labelledby="setgallery"
        aria-modal="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalCenterTitle">{{ __('Image Gallery') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="top-area">
                        <div id="error-message" class="alert alert-danger" style="display: none;">
                            <strong>{{ __('Error!') }}</strong> <span id="error-text"></span>
                        </div>
                        <div class="row">
                            <div class="col-sm-6 text-right">
                                <div class="upload-img-btn">
                                    <form method="POST" enctype="multipart/form-data" id="form-gallery">
                                        {{ csrf_field() }}
                                        <input type="hidden" id="property_id" name="property_id"
                                            value="{{ $property->id }}">
                                        <input type="file" name="gallery[]" class="hidden"
                                            id="property_upload_gallery_edit" accept="image/*" multiple>
                                        <label id="property_gallery_edit" class="pt-2">
                                            <i class="icofont-upload-alt"></i>{{ __('Upload File') }}
                                        </label>
                                    </form>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <a href="javascript:;" class="upload-done" data-dismiss="modal">
                                    <i class="fas fa-check"></i> {{ __('Done') }}
                                </a>
                                <p id="error-text" style="display: none; margin-top: 5px;"></p>
                            </div>
                            <div class="col-sm-12 text-center">
                                <small>{{ __('You can upload multiple Images.') }}</small>
                            </div>
                        </div>
                    </div>
                    <div class="gallery-images">
                        <div class="selected-image">
                            <div class="row">
                                @if ($property->galleries)
                                    @foreach ($property->galleries as $gallery)
                                        <div class="col-sm-6">
                                            <div class="img gallery-img">
                                                <span class="remove-img">
                                                    <i class="fas fa-times"></i>
                                                    <input type="hidden" value="{{ $gallery->id }}">
                                                </span>
                                                <a href="{{ asset('assets/images/' . $gallery->photo) }}"
                                                    target="_blank">
                                                    <img src="{{ asset('assets/images/' . $gallery->photo) }}"
                                                        alt="gallery image" width="100px">
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="col-12 text-center">
                                        <p>{{ __('No images found.') }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="{{ asset('assets/admin/js/image_gallary.js') }}"></script>
    <script>
        // var mainurl = "{{ url('/') }}";
        document.addEventListener('DOMContentLoaded', function() {
            const floorPlansContainer = document.getElementById('floor-plans-container');
            const addNewFloorPlanBtn = document.getElementById('add-new-floor-plan-btn');

            addNewFloorPlanBtn.addEventListener('click', function() {
                const newField = document.createElement('div');
                newField.classList.add('row', 'floor-plan-field', 'mt-3');
                newField.innerHTML = `
            <div class="col-md-4">
                <div class="form-group">
                    <input type="hidden" name="floor_id[]" value="">
                    <input type="text" class="form-control" name="floor_names[]" placeholder="Floor Name (E.g: Ground Floor...)">
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <select class="form-control" name="floor_sizes[]">
                        <option value="" disabled selected>Select Type</option>
                        <option value="1 RK">1 RK</option>
                        <option value="1 BHK">1 BHK</option>
                        <option value="1.5 BHK">1.5 BHK</option>
                        <option value="2 BHK">2 BHK</option>
                        <option value="2.5 BHK">2.5 BHK</option>
                        <option value="3 BHK">3 BHK</option>
                        <option value="3.5 BHK">3.5 BHK</option>
                        <option value="4 BHK">4 BHK</option>
                        <option value="4.5 BHK">4.5 BHK</option>
                        <option value="5 BHK">5 BHK</option>
                        <option value="5.5 BHK">5.5 BHK</option>
                        <option value="6 BHK">6 BHK</option>
                        <option value="6.5 BHK">6.5 BHK</option>
                        <option value="7 BHK">7 BHK</option>    
                        <option value="7+ BHK">7+ BHK</option>
                    </select>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group mt-2">
                    <input type="file" class="form-control" name="floor_images[]" accept="image/*">
                </div>
            </div>
            <div class="col-md-1 d-flex align-items-center">
                <button type="button" class="btn btn-secondary btn-sm remove-floor-plan-btn">X</button>
            </div>`;

                floorPlansContainer.appendChild(newField);

                const fileInput = newField.querySelector('input[type="file"]');
                const previewImage = newField.querySelector('.back-preview-image');

                fileInput.addEventListener('change', function(e) {
                    const file = e.target.files[0];
                    if (file) {
                        const reader = new FileReader();
                        reader.onload = function(event) {
                            previewImage.style.backgroundImage = `url(${event.target.result})`;
                        };
                        reader.readAsDataURL(file);
                    }
                });
            });

            floorPlansContainer.addEventListener('click', function(e) {
                if (e.target.classList.contains('remove-floor-plan-btn')) {
                    e.target.closest('.floor-plan-field').remove();
                }
            });
        });
        $(document).ready(function() {
            $('.upload-done').on('click', function() {
                $('#setgallery').modal('hide');

                $('body').removeClass('modal-open');
                $('.modal-backdrop').remove();

                $('#form-gallery')[0].reset();
                $('#property_upload_gallery_edit').val('');
            });
        });

        $(document).ready(function() {
            $('#property-form').on('submit', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    $('#error-message').show();

                    e.preventDefault();
                } else {
                    $('#error-message').hide();
                }
            });
        });

        $(document).ready(function() {
            $('.upload-done').on('click', function(e) {
                var uploadedImagesCount = $('.gallery-images .gallery-img').length;
                if (uploadedImagesCount < 4) {
                    alert('Please upload at least 4 images before proceeding.');
                    e.preventDefault();
                }
            });
        });
        // IMPROVED: Rejection Form Handling with debugging
        $('#submit-reason-btn').on('click', function(e) {
            e.preventDefault();

            var url = $('#rejection-form-url').val();
            var csrfToken = $('meta[name="csrf-token"]').attr('content') || $('input[name="_token"]').val();

            // Gather selected reasons (checkboxes)
            let selectedReasons = [];
            $('input[name="reason[]"]:checked').each(function() {
                selectedReasons.push($(this).val());
            });

            // Add custom reason if filled
            let customReason = $('#custom_reason').val();
            if (customReason && customReason.trim() !== '') {
                selectedReasons.push(customReason.trim());
            }

            // Debug
            console.log('Selected reasons:', selectedReasons);

            if (selectedReasons.length === 0) {
                alert('Please select or enter at least one reason.');
                return;
            }

            // Disable button
            var submitBtn = $(this);
            submitBtn.prop('disabled', true);
            submitBtn.html(
                '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Processing...'
            );

            $.ajax({
                url: url,
                type: 'POST',
                data: {
                    _token: csrfToken,
                    reason: selectedReasons
                },
                dataType: 'json',
                success: function(response) {
                    console.log('Success response:', response);
                    if (response.success) {
                        alert('Rejection reason saved successfully!');
                        $('#custom_reason').val('');
                        $('input[name="reason[]"]').prop('checked', false);

                        if (response.redirect) {
                            window.location.href = response.redirect;
                        }
                    } else {
                        alert(response.message || 'Failed to save rejection reason.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error:', error);
                    console.error('Response:', xhr.responseText);
                    alert('An error occurred while saving the rejection reason.');
                },
                complete: function() {
                    submitBtn.prop('disabled', false).html('Submit Reason');
                }
            });
        });
    </script>
@endsection
