@extends('layouts.admin')
<style>
    .table-smaller {
        font-size: 14px;
        white-space: nowrap;
    }
</style>
@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Manage All Properties') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('Manage All Properties') }}</a></li>
            </ol>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <small>From Date</small>
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                </div>
                                <input type="date" id="from_date" class="form-control form-control-sm calender"
                                    placeholder="From Date">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <small>To Date</small>
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                </div>
                                <input type="date" id="to_date" class="form-control form-control-sm calender"
                                    placeholder="To Date">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <small>Filter by</small>
                            <select id="date_type" class="form-control form-control-sm mb-2">
                                <option value="" selected>Select Date Type</option>
                                <option value="created_at">Create Date</option>
                                <option value="updated_at">Update Date</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <small>Property Type</small>
                            <div class="input-group mb-2">
                                <select id="type_filter" class="form-control form-control-sm">
                                    <option value="">{{ __('Property Type') }}</option>
                                    <option value="commercial">{{ __('Commercial') }}</option>
                                    <option value="residential">{{ __('Residential') }}</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-3">
                            {{-- <small>Select Property Category</small> --}}
                            <div class="input-group mb-2">
                                <select id="category_filter" class="form-control form-control-sm">
                                    <option value="">{{ __('Select Category') }}</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->title }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <!--<small>Sale Type</small>-->
                            <div class="input-group mb-2">
                                <select id="sale_filter" class="form-control form-control-sm">
                                    <option value="">{{ __('All Type') }}</option>
                                    <option value="for_sell">{{ __('Sell') }}</option>
                                    <option value="for_rent">{{ __('Rent') }}</option>
                                    <option value="for_pg">{{ __('PG') }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <!--<small>Status</small>-->
                            <div class="input-group mb-2">
                                <select id="status_filter" class="form-control form-control-sm">
                                    <option value="">{{ __('Select Status') }}</option>
                                    <option value="0">{{ __('Pending') }}</option>
                                    <option value="1">{{ __('Approved') }}</option>
                                    <option value="2">{{ __('Rejected') }}</option>
                                    <option value="3">{{ __('Re-Approve') }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <!--<small>Status</small>-->
                            <div class="input-group mb-2">
                                <select id="primium_filter" class="form-control form-control-sm">
                                    <option value="">{{ __('Select Listing Type') }}</option>
                                    <option value="1">{{ __('Premium Listings') }}</option>
                                    <option value="0">{{ __('Free Listings') }}</option>
                                    <option value="2">{{ __('Expired Listings') }}</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-2 d-flex align-items-center">
                            <button id="filter_button" class="btn btn-primary btn-sm mr-2">Filter</button>
                            <button id="reset_button" class="btn btn-secondary btn-sm">Reset</button>
                        </div>
                    </div>
                </div>
            </div>
            @include('includes.admin.form-success')
            <div class="card mb-4">
                <div class="table-responsive p-2" style="overflow-x: auto;">
                    <table id="geniustable" class="table table-bordered table-striped table-smaller" cellspacing="0"
                        width="100%">
                        <thead class="thead-light">
                            <tr>
                                <th>{{ __('Image') }}</th>
                                <th>{{ __('Post') }}</th>
                                <th>{{ __('Category') }}</th>
                                <th>{{ __('Create Date') }}</th>
                                <th>{{ __('Update Date') }}</th>
                                <th>{{ __('Property Info') }}</th>
                                <th>{{ __('Price') }}</th>
                                <th>{{ __('Type') }}</th>
                                <th>{{ __('Status') }}</th>
                                <th>{{ __('Options') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- User Detail Modal -->
    <div class="modal fade" id="userDetailModal" tabindex="-1" aria-labelledby="userDetailModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">User Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="userDetailContent">
                    Loading...
                </div>
            </div>
        </div>
    </div>
    @includeIf('partials.admin.status')
@endsection
@section('scripts')
    <script>
        $(function() {
            $('body').tooltip({
                selector: '[title]'
            });
        });
        "use strict";
        $(document).ready(function() {
            $('[data-toggle="tooltip"]').tooltip();

            var table = $('#geniustable').DataTable({
                ordering: true,
                processing: true,
                serverSide: true,
                searching: true,
                lengthMenu: [
                    [10, 50, 100, 200, 300, 500, 1000, 2000, 5000, 10000],
                    [10, 50, 100, 200, 300, 500, 1000, 2000, 5000, 10000]
                ],
                pageLength: 50,
                ajax: {
                    url: "{{ route('admin.properties.datatables') }}",
                    data: function(d) {
                        d.from_date = $('#from_date').val();
                        d.to_date = $('#to_date').val();
                        d.date_type = $('#date_type').val(); // created_at or updated_at
                        d.sale_id = $('#sale_filter').val();
                        d.type_id = $('#type_filter').val();
                        d.category_id = $('#category_filter').val();
                        d.status = $('#status_filter').val();
                        d.is_primium = $('#primium_filter').val();
                    }
                },
                columnDefs: [{
                    targets: 0,
                    width: '60px'
                }],
                columns: [{
                        data: 'photo',
                        name: 'photo',
                        searchable: false,
                        orderable: false
                    },
                    {
                        data: 'post',
                        name: 'post'
                    },
                    {
                        data: 'category_id',
                        name: 'category_id'
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                    {
                        data: 'updated_at',
                        name: 'updated_at'
                    },
                    {
                        data: 'extra_info',
                        name: 'extra_info'
                    },
                    {
                        data: 'price',
                        name: 'price'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'action',
                        searchable: false,
                        orderable: false
                    }
                ],
                language: {
                    processing: "<img src='{{ asset('assets/images/' . $gs->admin_loader) }}'>"
                }
            });

            // Filter reload
            $('#filter_button').on('click', function() {
                table.ajax.reload();
            });

            // Reset filters
            $('#reset_button').on('click', function() {
                $('#from_date').val('');
                $('#to_date').val('');
                $('#date_type').val('created_at'); // reset to default
                $('#sale_filter').val('');
                $('#type_filter').val('');
                $('#category_filter').val('');
                $('#status_filter').val('');
                $('#primium_filter').val('');
                table.ajax.reload();
            });

            // Dynamic Add New dropdown
            let users = @json($users);
            let dropdownHTML = `
                <div class="col-sm-12 col-md-4 pr-3 text-right">
                    <div class="dropdown d-inline-block" id="userDropdownWrapper">
                        <button class="btn btn-primary dropdown-toggle" type="button" id="addNewDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-plus"></i> {{ __('Post Property') }}
                        </button>
                        <div class="dropdown-menu dropdown-menu-right shadow" aria-labelledby="addNewDropdown" style="max-height: 250px; overflow-y: auto; width: 250px;">
                            ${users.map(user => `<a class="dropdown-item text-truncate" href="{{ url('admin/properties/create') }}/${user.id}">${user.name}</a>`).join('')}
                        </div>
                    </div>
                </div>
            `;
            $(".btn-area").append(dropdownHTML);

            // Auto-close dropdown
            $(document).on('click', '#addNewDropdown', function() {
                clearTimeout($.data(this, 'timer'));
                const button = this;
                const timer = setTimeout(function() {
                    $(button).dropdown('toggle');
                }, 5000);
                $(this).data('timer', timer);
            });

            // Close on outside click
            $(document).on('click', function(e) {
                const target = $(e.target);
                if (!target.closest('#userDropdownWrapper').length && $('.dropdown-menu.show').length) {
                    $('#addNewDropdown').dropdown('toggle');
                }
            });
        });
    </script>
@endsection
