@extends('layouts.admin')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
@section('styles')
@section('content')
    <div class="card">
        <div class="d-flex justify-content-center">
            @php
                $steps = [
                    1 => 'Basic Details',
                    2 => 'Property Details',
                    3 => 'Location Details',
                    4 => 'Photos & Videos',
                ];
                $currentStep = request()->route()->getName();
                preg_match('/step_(\d+)/', $currentStep, $matches);
                $activeStep = isset($matches[1]) ? (int) $matches[1] : 1;
            @endphp
            <div class="steps-container my-1">
                @foreach ($steps as $step => $label)
                    <div class="step-item">
                        <a href="#" class="step-circle {{ $step == $activeStep ? 'active' : '' }}">
                            {{ $step }}
                        </a>
                        <span class="step-label">{{ $label }}</span>
                        @if ($step < count($steps))
                            <div class="step-line">
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <div class="row justify-content-center mt-3">
        <div class="col-md-12">
            <form method="POST"
                action="{{ isset($property->id) ? route('admin.properties.store_plot_rent', ['id' => $property->id]) : route('admin.properties.store_plot_rent') }}">
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-12">
                        <x-normal-input label="Plot Name" name="name" type="text" placeholder="Enter Plot Name"
                            :value="old('name', $property->name ?? '')" />

                        <div class="card my-1">
                            <div class="card-body">
                                <div class="col-md-10">
                                    <h6 class="my-2">{{ __('Possession Status') }}</h6>
                                    <div class="form-group">
                                        @foreach (['immediate' => 'Immediate', 'future' => 'In Future'] as $val => $label)
                                            <input type="radio" id="possession_{{ $val }}"
                                                name="possession_status" value="{{ $val }}"
                                                onchange="togglePossessionDate()"
                                                {{ old('possession_status', $property->possession_status ?? '') == $val ? 'checked' : '' }}>
                                            <label for="possession_{{ $val }}"
                                                class="me-3">{{ $label }}</label>
                                        @endforeach
                                    </div>
                                    @error('possession_status')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                                <div id="possession_date_group" style="display: none;">
                                    <h6 class="m-0">{{ __('Available From') }}</h6><br>
                                    <div class="form-group w-25">
                                        <input type="date" name="possession_date" class="form-control calender"
                                            value="{{ old('possession_date', $property->plot_possession_date ?? '') }}">
                                    </div>
                                    @error('plot_possession_date')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>

                        </div>

                        <div class="card my-1" id="zone_type">
                            <div class="card-body">
                                <div class="form-group">
                                    <h6 class="my-2">{{ __('Zone Type') }}</h6>
                                    <div class="d-flex flex-wrap">
                                        <div>
                                            <input type="radio" id="industrial" name="zone_type" value="industrial"
                                                {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'industrial' ? 'checked' : '' }}>
                                            <label for="industrial">&nbsp;Industrial &nbsp;</label>

                                            <input type="radio" id="commercial" name="zone_type" value="commercial"
                                                {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'commercial' ? 'checked' : '' }}>
                                            <label for="commercial">&nbsp;Commercial &nbsp;</label>

                                            <input type="radio" id="residential" name="zone_type" value="residential"
                                                {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'residential' ? 'checked' : '' }}>
                                            <label for="residential">&nbsp;Residential &nbsp;</label>

                                            <input type="radio" id="special_economic_zone" name="zone_type"
                                                value="special-economic-zone"
                                                {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'special-economic-zone' ? 'checked' : '' }}>
                                            <label for="special_economic_zone">&nbsp;Special Economic Zone &nbsp;</label>

                                            <input type="radio" id="open_space" name="zone_type" value="open-space"
                                                {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'open-space' ? 'checked' : '' }}>
                                            <label for="open_space">&nbsp;Open Space &nbsp;</label>

                                            <input type="radio" id="agricultural_zone" name="zone_type"
                                                value="agricultural-zone"
                                                {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'agricultural-zone' ? 'checked' : '' }}>
                                            <label for="agricultural_zone">&nbsp;Agricultural Zone &nbsp;</label>

                                            <input type="radio" id="other_zone" name="zone_type" value="other"
                                                {{ old('zone_type', isset($property) ? $property->zone_type : '') == 'other' ? 'checked' : '' }}>
                                            <label for="other_zone">&nbsp;Other &nbsp;</label>
                                        </div>
                                    </div>
                                    <!-- Error message -->
                                    @error('zone_type')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <x-area-with-unit areaLabel="Plot Area" unitLabel="Select Unit" :showDimensions="true" :selectedArea="old('plot_area', $property->plot_area ?? '')"
                            :selectedUnit="old('area_unit', $property->area_unit ?? '')" :selectedLength="old('plot_length', $property->plot_length ?? '')" :selectedWidth="old('plot_width', $property->plot_width ?? '')" id="main-area-unit" />

                        <x-radio-group label="Ownership" name="ownership" :options="[
                            'pre-holder' => 'Pre-Holder',
                            'lease-holder' => 'Lease-Holder',
                            'co-operative-society' => 'Co-Operative Society',
                            'power-of-attorney' => 'Power of Attorney',
                        ]" :selected="old('ownership', $property->ownership ?? null)" />


                        <x-normal-input label="Property Expected Price ( in Rs )" name="price" type="number"
                            placeholder="" :value="old('price', $property->price ?? '')" />

                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('admin.properties.step_1', $property->id ?? null) }}" id="back-btn"
                                class="btn btn-secondary">{{ __('Back') }}</a>
                            <button type="submit" id="submit-btn" class="btn btn-primary">{{ __('Next') }}</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        function togglePossessionDate() {
            const futureRadio = document.getElementById('possession_future');
            const dateGroup = document.getElementById('possession_date_group');

            if (futureRadio.checked) {
                dateGroup.style.display = 'block';
            } else {
                dateGroup.style.display = 'none';
            }
        }
        window.addEventListener('DOMContentLoaded', togglePossessionDate);
    </script>
@endsection
