@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Lead List') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>

                <li class="breadcrumb-item"><a href="{{ route('admin.user.index') }}">{{ __('Lead List') }}</a></li>
            </ol>
        </div>
    </div>
    <!-- Row -->
    <div class="row mb-3">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <small>From Date</small>
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                </div>
                                <input type="date" id="from_date" class="form-control form-control-sm calender"
                                    placeholder="From Date">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <small>To Date</small>
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                </div>
                                <input type="date" id="to_date" class="form-control form-control-sm calender"
                                    placeholder="To Date">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group mb-2 mt-4">
                                <div class="input-group-prepend ">
                                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                                </div>
                                <select id="user_type" class="form-control form-control-sm">
                                    <option value="" selected>Select User Type</option>
                                    <option value="owner">Property Owner</option>
                                    <option value="agent">Property Agent</option>
                                    <option value="builder/developer">Builder/Developer</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="input-group mb-2 mt-4">
                                <div class="input-group-prepend ">
                                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                                </div>
                                <select id="enquiry_count" class="form-control form-control-sm">
                                    <option value="" selected>Enquiry Count</option>
                                    @for ($i = 5; $i <= 50; $i += 5)
                                        <option value="{{ $i }}">{{ $i }}</option>
                                    @endfor
                                    <option value="100">50+</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-2 d-flex align-items-center">
                            <button id="filter_button" class="btn btn-primary btn-sm mr-2">Filter</button>
                            <button id="reset_button" class="btn btn-secondary btn-sm">Reset</button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="row mt-3">
        <!-- Datatables -->
        <div class="col-lg-12">
            @include('includes.admin.form-success')
            <div class="card mb-4">
                <div class="table-responsive p-3">
                    <table id="geniustable" class="table table-hover dt-responsive table-smaller" cellspacing="0"
                        width="100%">
                        <thead class="thead-light">
                            <tr>
                                <th>{{ __('S.No') }}</th>
                                <th>{{ __('Create Date') }}</th>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Type') }}</th>
                                <th>{{ __('Mobile') }}</th>
                                <th>{{ __('City') }}</th>
                                <th>{{ __('Listings') }}</th>
                                <th>{{ __('Enquiries') }}</th>
                                <th>{{ __('Email') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!-- DataTable with Hover -->

    </div>
    <!--Row-->

@endsection

<script>
    const leadsPropertyRoute = "{{ route('admin.leads', ':id') }}";
</script>

@section('scripts')
    <script type="text/javascript">
        'use strict';

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: {
                url: '{{ route('admin-leads-datatables') }}',
                data: function(d) {
                    d.from_date = $('#from_date').val();
                    d.to_date = $('#to_date').val();
                    d.user_type = $('#user_type').val();
                    d.enquiry_count = $('#enquiry_count').val();
                }
            },
            columns: [{
                    data: null,
                    name: 'sno',
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    },
                    orderable: false,
                    searchable: false
                },
               
                {
                    data: 'created_at',
                    name: 'created_at',
                    render: function(data) {
                        if (data) {
                            const date = new Date(data);
                            return date.toLocaleDateString('en-GB');
                        }
                        return '';
                    }
                },
                 {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'user_type',
                    name: 'user_type'
                },
                {
                    data: 'phone',
                    name: 'phone'
                },
                 {
                    data: 'city',
                    name: 'city'
                },
               
                {
                    data: 'properties_count',
                    name: 'properties_count',
                    render: function(data, type, row) {
                        if (data) {
                            // If enquiries_count is 3 or more, make it clickable
                            if (row.enquiries_count >= 3) {
                                let url = leadsPropertyRoute.replace(':id', row.id);
                                return `<a href="${url}">${data}</a>`;
                            } 
                            // Otherwise, just show the number without a link
                            return `<span class="text-muted">${data}</span>`;
                        }
                        return 0;
                    },
                                    searchable: false,
                    orderable: false
                },
                {
                    data: 'enquiries_count',
                    name: 'enquiries_count',
                }, 
                {
                    data: 'email',
                    name: 'email'
                },
               
            ],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            }
        });

        $('#filter_button').on('click', function() {
            table.ajax.reload();
        });

        // Handle reset button click
        $('#reset_button').on('click', function() {
            $('#from_date').val('');
            $('#to_date').val('');
            $('#user_type').val('');
            $('#enquiry_count').val('');
            table.ajax.reload();
        });
    </script>
@endsection
