@extends('layouts.admin')
@section('content')
<div class="card">
    <div class="d-sm-flex align-items-center justify-content-between">
        <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Leads Details List') }}</h5>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item"><a href="javascript:;">{{ __('Leads Details List') }}</a></li>
        </ol>
    </div>
<div class="row mt-3">
    <div class="col-lg-12">
        @include('includes.admin.form-success')
        <div class="card mb-4">
            <div class="table-responsive p-3">
                <table id="properties-table" class="table table-hover table-smaller" width="100%">
                    <thead class="thead-light">
                        <tr>
                            <th>{{ __('S.No') }}</th>
                            <th>{{ __('Created') }}</th>
                            <th>{{ __('Property Name') }}</th>
                            <th>{{ __('View Property') }}</th>
                            <th>{{ __('No. Of Enquiry') }}</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
$(document).ready(function() {
    const table = $('#properties-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('admin.leads.datatables', $id) }}",
        columns: [ {
                    data: null,
                    name: 'sno',
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    },
                    orderable: false,
                    searchable: false
                },
            { data: 'created_at', width: '100px' },
            { data: 'name_with_status' },
            { data: 'view_btn' },
            { data: 'enquiries_count' }
        ],
        language: {
            processing: "<img src='{{ asset('assets/images/'.$gs->admin_loader) }}'>"
        }
    });
});
</script>
@endsection