@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('Infra Info SMS API Configuration') }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('SMS Settings') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-md-2">
            @include('includes.admin.roles.settings')
        </div>
        <div class="col-lg-10">
            <div class="card mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">{{ __('Infra Info Form') }} </h6>
                </div>

                <div class="card-body">
                    <div class="gocover"
                        style="background: url({{ asset('assets/images/' . $gs->admin_loader) }}) no-repeat scroll center center rgba(45, 45, 45, 0.5);">
                    </div>
                    <form class="geniusform" action="{{ route('admin.gs.update') }}" method="POST"
                        enctype="multipart/form-data">

                        @include('includes.admin.form-both')

                        {{ csrf_field() }}
                        <label>{{ __('Company Name :') }} Infra Infotech</label><br>
                        <label>{{ __('Company Website URL') }} </label>
                        <a href="https://infrainfotech.com" target="_blank"
                            class="text-primary">https://infrainfotech.com</a>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="infra_senderid">{{ __('Sender Id ') }}</label>
                                    <input type="text" class="form-control" id="infra_senderid" name="infra_senderid"
                                        value="{{ $gs->infra_senderid }}">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="infra_template_id">{{ __('Template Id') }}</label>
                                    <input type="text" class="form-control" id="infra_template_id"
                                        name="infra_template_id" value="{{ $gs->infra_template_id }}">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="inp-name">{{ __('Status') }}</label>
                                    <select class="form-control mb-3" name="infra_status">
                                        <option value="1" {{ $gs->infra_status == 1 ? 'selected' : '' }}>
                                            {{ __('Activate') }}</option>
                                        <option value="0" {{ $gs->infra_status == 0 ? 'selected' : '' }}>
                                            {{ __('Deactivate') }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <button type="submit" id="submit-btn" class="btn btn-primary w-100">{{ __('Submit') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
