@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between py-3">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ $user->name }}</h5>
            <ol class="breadcrumb py-0 m-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('User') }}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.user.index') }}">{{ __('Users') }}</a></li>
            </ol>
        </div>
    </div>
    <div class="row mt-3">
        <div class="col-lg-12">
            @include('includes.admin.form-success')
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif
            <div class="card">
                <div class="row my-5">
                    <div class="col-md-2">
                        <div class="user-image">
                            @if ($user->is_provider == 1)
                                <img src="{{ $user->photo ? asset($user->photo) : asset('assets/images/noimage.png') }}"
                                    alt="No Image">
                            @else
                                <img class=""
                                    src="{{ $user->photo ? asset('assets/images/' . $user->photo) : asset('assets/images/noimage.png') }}"
                                    alt="No Image">
                            @endif
                            <a class="mybtn1 btn btn-primary" data-email="{{ $user->email }}" data-toggle="modal"
                                data-target="#vendorform" href="">{{ __('Send Message') }}</a>
                        </div>
                    </div>
                    <div class="col-md-5 mt-5">
                        <div class="table-responsive show-table">
                            <table class="table">
                                <tr>
                                    <th>{{ __('ID#') }}</th>
                                    <td>{{ $user->id }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('User Type') }}</th>
                                    <td>{{ ucfirst($user->user_type) }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('Username') }}</th>
                                    <td>{{ $user->name }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('Email') }}</th>
                                    <td>{{ $user->email }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('Phone No.') }}</th>
                                    <td>{{ $user->phone }}</td>
                                </tr>
                                <tr>
                                    <th>{{ __('Address') }}</th>
                                    <td>{{ $user->address }}</td>
                                </tr>

                                <tr>
                                    <th>{{ __('City') }}</th>
                                    <td>{{ $user->city }}</td>
                                </tr>

                                <tr>
                                    <th>{{ __('Zip Code') }}</th>
                                    <td>{{ $user->zip }}</td>
                                </tr>


                            </table>
                        </div>
                    </div>
                    <div class="col-md-4 mx-auto ">
                        <div class="card p-4">
                            <form action="{{ route('admin.user.plan.activate') }}" method="POST">
                                @csrf
                                <input type="hidden" name="user_id" value="{{ $user->id }}">
                                <div class="form-group">
                                    <label for="">@lang('Select Plan')</label>
                                    <select class="form-control" name="type" required>
                                        @foreach ($plans as $plan)
                                            <option value="{{ $plan->id }}"
                                                @if (isset($activePlan) && $activePlan->id == $plan->id) selected @endif>
                                                {{ ucwords($plan->title) . ' for ' . $plan->plan_type }} days
                                            </option>
                                        @endforeach
                                    </select>

                                </div>
                                <button type="submit" class="btn btn-primary w-100">{{ __('Activate') }}</button>
                            </form>

                            @if ($activePlan)
                                @php
                                    $endDate = $user->plan_end_date ? \Carbon\Carbon::parse($user->plan_end_date) : null;
                                    $startDate = ($endDate && $activePlan->plan_type) ? $endDate->copy()->subDays($activePlan->plan_type) : null;
                                @endphp

                               <div class="mt-3 text-center p-3 border rounded shadow-sm bg-light">
                                    <h5 class="text-success mb-3">@lang('Active Plan')</h5>
                                
                                    <p><strong>Package For:</strong> {{ ucwords($activePlan->user_type ?? '?') }}</p>
                                    <p><strong>Property Type:</strong> {{ ucwords($activePlan->property_type ?? '?') }}</p>
                                    <p><strong>Sale Type:</strong> {{ ucwords(str_replace('_', ' ', $activePlan->sale_type ?? '?')) }}</p>
                                    <p><strong>Package Title:</strong> {{ ucwords($activePlan->title ?? '?') }}</p>
                                    <p><strong>Package Sub-Title:</strong> {{ ucwords($activePlan->subtitle ?? '?') }}</p>
                                    <p><strong>Add Validity:</strong> {{ $activePlan->plan_type ?? '?' }} days</p>
                                    <p><strong>Package Price:</strong> ₹{{ $activePlan->price ?? '?' }}</p>
                                    <p><strong>Listing Limit:</strong> {{ $activePlan->post_limit ?? '?' }}</p>
                                    <p><strong>Ad Duration:</strong> {{ $activePlan->post_duration ?? '?' }}</p>
                                
                                    <p class="text-muted mb-1">
                                        <strong>@lang('Activated At'):</strong>
                                        {{ $startDate ? $startDate->format('d M, Y h:i A') : '?' }}
                                    </p>
                                    <p class="text-muted">
                                        <strong>@lang('Expires At'):</strong>
                                        {{ $endDate ? $endDate->format('d M, Y h:i A') : '?' }}
                                    </p>

                                    <p class="text-muted">
                                        <strong>@lang('Slot'):</strong>
                                        {{ $activePlan->slot ?? '-' }}
                                    </p>
                                    <p class="text-muted">
                                        <strong>@lang('Boost'):</strong>
                                        {{ $activePlan->boost ? $activePlan->boost."x" : '-' }}
                                    </p>
                                    
                                </div>

                            @else
                                <div class="mt-3 text-center text-muted">
                                    <p>@lang('No active plan')</p>
                                </div>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- DataTable with Hover -->
    </div>
    <div class="row mb-3">
    </div>
    <!--Row-->
    {{-- STATUS MODAL --}}
    <div class="modal fade confirm-modal" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="statusModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Update Status') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __('You are about to change the status.') }}</p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-success btn-ok">{{ __('Update') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- STATUS MODAL ENDS --}}


    {{-- MESSAGE MODAL --}}
    <div class="sub-categori">
        <div class="modal fade confirm-modal" id="vendorform" tabindex="-1" role="dialog"
            aria-labelledby="vendorformLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="vendorformLabel">{{ __('Send Message') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid p-0">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="contact-form">
                                        <form id="emailreply1">
                                            {{ csrf_field() }}

                                            <div class="form-group">
                                                <input type="email" class="form-control" id="eml1" name="to"
                                                    placeholder="{{ __('Email') }}" value="{{ $user->email }}"
                                                    required="">
                                            </div>
                                            <div class="form-group">
                                                <input type="text" class="form-control" id="subj1" name="subject"
                                                    placeholder="{{ __('Subject') }}" value="" required="">
                                            </div>
                                            <div class="form-group">
                                                <textarea class="form-control" name="message" id="msg1" cols="20" rows="6"
                                                    placeholder="{{ __('Your Message') }} " required=""></textarea>
                                            </div>



                                            <button class="submit-btn btn btn-primary text-center" id="emlsub1"
                                                type="submit">{{ __('Send Message') }}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- MESSAGE MODAL ENDS --}}

    {{-- DELETE MODAL --}}

    <div class="modal fade confirm-modal" id="deleteModal" tabindex="-1" role="dialog"
        aria-labelledby="deleteModalTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Confirm Delete') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">{{ __('You are about to delete this Blog.') }}</p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-danger btn-ok">{{ __('Delete') }}</a>
                </div>
            </div>
        </div>
    </div>

    {{-- DELETE MODAL ENDS --}}
@endsection
