@extends('layouts.admin')

@section('content')
    <div class="card">
        <div class="d-sm-flex align-items-center justify-content-between">
            <h5 class=" mb-0 text-gray-800 pl-3">{{ __('View Contacts') }}</h5>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                <li class="breadcrumb-item"><a href="javascript:;">{{ __('View Contacts') }}</a></li>
            </ol>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-12">
            @include('includes.admin.form-success')
            <div class="card mb-4">
                <div class="table-responsive-sm p-2">
                    <div class="d-flex flex-column flex-sm-row align-items-sm-center mb-2">
                        <div id="custom-controls" class="w-100">
                        </div>
                    </div>
                    <table id="geniustable" class="table table-hover table-sm dt-responsive" cellspacing="0" width="100%">
                        <thead class="thead-light">
                            <tr>
                                <th class="text-nowrap">{{ __('Date') }}</th>
                                <th class="text-nowrap">{{ __('Name') }}</th>
                                <th class="text-nowrap">{{ __('Property title') }}</th>
                                <th class="text-nowrap">{{ __('Email') }}</th>
                                <th class="text-nowrap">{{ __('Phone') }}</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <style>
        /* Hide default DataTables controls */
        .dataTables_length,
        .dataTables_filter,
        .dataTables_paginate,
        .dataTables_info {
            display: none !important;
        }

        #custom-controls {
            display: flex;
            flex-direction: row;
            align-items: center;
            gap: 1rem;
        }

        @media (max-width: 575.98px) {
            #custom-controls {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
            }
        }

        @media (max-width: 575.98px) {
            .table-responsive-sm {
                padding: 0.5rem !important;
            }

            .card.mb-4 {
                margin-bottom: 0.5rem !important;
            }

            .table th,
            .table td {
                font-size: 13px !important;
                padding: 0.3rem 0.4rem !important;
            }

            .breadcrumb {
                font-size: 13px !important;
                padding-left: 0.5rem !important;
            }

            .d-sm-flex.align-items-center {
                flex-direction: column;
                align-items: flex-start !important;
                padding: 0.5rem 0.5rem 0 0.5rem !important;
            }
        }
    </style>


    @includeIf('partials.admin.status')
    <div class="modal fade confirm-modal" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('Confirm Delete') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p class="text-center">
                        {{ __('You are about to delete this Enquiry. Every informtation under this enquiry will be deleted.') }}
                    </p>
                    <p class="text-center">{{ __('Do you want to proceed?') }}</p>
                </div>
                <div class="modal-footer">
                    <a href="javascript:;" class="btn btn-secondary" data-dismiss="modal">{{ __('Cancel') }}</a>
                    <a href="javascript:;" class="btn btn-danger btn-ok">{{ __('Delete') }}</a>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('scripts')
    <script type="text/javascript">
        "use strict";

        var table = $('#geniustable').DataTable({
            ordering: false,
            processing: true,
            serverSide: true,
            searching: true,
            ajax: "{{ route('admin.properties.enquiries.datatables') }}",
            columns: [{
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'details',
                    name: 'details'
                },
                {
                    data: 'property_id',
                    name: 'property_id'
                },
                {
                    data: 'email',
                    name: 'email'
                },
                {
                    data: 'phone',
                    name: 'phone'
                },

            ],
            language: {
                processing: '<img src="{{ asset('assets/images/' . $gs->admin_loader) }}">'
            },
            drawCallback: function(settings) {
                // Move DataTables controls to custom container
                var length = $(this.api().table().container()).find('.dataTables_length');
                var filter = $(this.api().table().container()).find('.dataTables_filter');
                var paginate = $(this.api().table().container()).find('.dataTables_paginate');
                var info = $(this.api().table().container()).find('.dataTables_info');
                var custom = $('#custom-controls');
                custom.empty();
                custom.append(length.addClass('mb-0 mr-2'));
                custom.append(filter.addClass('mb-0'));
                custom.append(info.addClass('mb-0 ml-2'));
                custom.append(paginate.addClass('mb-0 ml-auto'));
            }
        });
    </script>
@endsection

